/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.type;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.compare.IComparable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.name.IHasName;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@Immutable
public class ObjectType
implements IComparable<ObjectType>,
IHasName {
    private final String m_sName;
    private int m_nHashCode = 0;

    public ObjectType(@NonNull @Nonempty String string) {
        this.m_sName = ValueEnforcer.notEmpty(string, "Name");
    }

    @Override
    public @NonNull @Nonempty String getName() {
        return this.m_sName;
    }

    @Override
    public int compareTo(@NonNull ObjectType objectType) {
        return this.m_sName.compareTo(objectType.m_sName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ObjectType objectType = (ObjectType)object;
        return this.m_sName.equals(objectType.m_sName);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_sName).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Name", this.m_sName).getToString();
    }
}

