/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.tostring.ToStringGenerator;
import java.io.InputStream;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;

@Immutable
public class HasInputStream
implements IHasInputStream {
    private final Supplier<? extends InputStream> m_aISP;
    private final boolean m_bReadMultiple;

    public HasInputStream(@NonNull Supplier<? extends InputStream> supplier, boolean bl) {
        this.m_aISP = ValueEnforcer.notNull(supplier, "ISP");
        this.m_bReadMultiple = bl;
    }

    @Override
    public final boolean isReadMultiple() {
        return this.m_bReadMultiple;
    }

    @Override
    public final InputStream getInputStream() {
        return this.m_aISP.get();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISP", this.m_aISP).append("ReadMultiple", this.m_bReadMultiple).getToString();
    }

    @ReturnsMutableCopy
    public static @NonNull HasInputStream multiple(@NonNull Supplier<? extends InputStream> supplier) {
        return new HasInputStream(supplier, true);
    }

    @ReturnsMutableCopy
    public static @NonNull HasInputStream once(@NonNull Supplier<? extends InputStream> supplier) {
        return new HasInputStream(supplier, false);
    }

    @ReturnsMutableCopy
    public static @NonNull IHasInputStream create(@NonNull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
        ValueEnforcer.notNull(nonBlockingByteArrayOutputStream, "BAOS");
        return new HISNBBAOS(nonBlockingByteArrayOutputStream);
    }

    @ReturnsMutableCopy
    public static @NonNull IHasInputStream create(byte @NonNull [] byArray) {
        ValueEnforcer.notNull(byArray, "Bytes");
        return new HISByteArray(byArray);
    }

    private static final class HISNBBAOS
    implements IHasInputStream {
        private final NonBlockingByteArrayOutputStream m_aBAOS;

        public HISNBBAOS(@NonNull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
            this.m_aBAOS = nonBlockingByteArrayOutputStream;
        }

        @Override
        public @NonNull InputStream getInputStream() {
            return this.m_aBAOS.getAsInputStream();
        }

        @Override
        public boolean isReadMultiple() {
            return true;
        }
    }

    private static final class HISByteArray
    implements IHasInputStream {
        private final byte[] m_aBytes;

        public HISByteArray(byte @NonNull [] byArray) {
            this.m_aBytes = byArray;
        }

        @Override
        public @NonNull InputStream getInputStream() {
            return new NonBlockingByteArrayInputStream(this.m_aBytes);
        }

        @Override
        public boolean isReadMultiple() {
            return true;
        }
    }
}

