/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.timing;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.state.IStoppable;
import com.helger.base.tostring.ToStringGenerator;
import java.time.Duration;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class StopWatch
implements IStoppable {
    private long m_nStartDT = 0L;
    private long m_nDurationNanos = 0L;

    protected StopWatch(boolean bl) {
        if (bl) {
            this.start();
        }
    }

    public @NonNull EChange reset() {
        if (this.m_nDurationNanos == 0L) {
            return EChange.UNCHANGED;
        }
        this.m_nDurationNanos = 0L;
        return EChange.CHANGED;
    }

    protected static final long getCurrentNanoTime() {
        return System.nanoTime();
    }

    public final @NonNull EChange start() {
        if (this.m_nStartDT > 0L) {
            return EChange.UNCHANGED;
        }
        this.m_nStartDT = StopWatch.getCurrentNanoTime();
        return EChange.CHANGED;
    }

    @Override
    public @NonNull EChange stop() {
        if (this.m_nStartDT == 0L) {
            return EChange.UNCHANGED;
        }
        long l = StopWatch.getCurrentNanoTime();
        this.m_nDurationNanos += l - this.m_nStartDT;
        this.m_nStartDT = 0L;
        return EChange.CHANGED;
    }

    public void restart() {
        this.stop();
        this.reset();
        this.start();
    }

    public boolean isStarted() {
        return this.m_nStartDT > 0L;
    }

    public boolean isStopped() {
        return this.m_nStartDT == 0L;
    }

    @Nonnegative
    public long getNanos() {
        return this.m_nDurationNanos;
    }

    @Nonnegative
    public long getMillis() {
        return this.m_nDurationNanos / 1000000L;
    }

    public @NonNull Duration getDuration() {
        return Duration.ofNanos(this.m_nDurationNanos);
    }

    @Nonnegative
    public long stopAndGetMillis() {
        this.stop();
        return this.getMillis();
    }

    public @NonNull Duration stopAndGetDuration() {
        this.stop();
        return this.getDuration();
    }

    public @NonNull Duration getLapDuration() {
        this.stop();
        Duration duration = this.getDuration();
        this.start();
        return duration;
    }

    public String toString() {
        return new ToStringGenerator(this).append("StartDT", this.m_nStartDT).append("DurationNanos", this.m_nDurationNanos).getToString();
    }

    @ReturnsMutableCopy
    public static @NonNull StopWatch createdStarted() {
        return new StopWatch(true);
    }

    @ReturnsMutableCopy
    public static @NonNull StopWatch createdStopped() {
        return new StopWatch(false);
    }

    public static @NonNull Duration runMeasured(@NonNull Runnable runnable) {
        StopWatch stopWatch = StopWatch.createdStarted();
        runnable.run();
        return stopWatch.stopAndGetDuration();
    }
}

