/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.thirdparty;

import com.helger.annotation.Nonempty;
import com.helger.base.lang.EnumHelper;
import com.helger.base.thirdparty.ILicense;
import com.helger.base.version.Version;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum ELicense implements ILicense
{
    APACHE1("apache1", "Apache License", new Version(1, 0), "https://www.apache.org/licenses/LICENSE-1.0.txt"),
    APACHE2("apache2", "Apache License", new Version(2, 0), "https://www.apache.org/licenses/LICENSE-2.0.txt"),
    MPL10("mpl10", "Mozilla Public License", new Version(1, 0), "https://www.mozilla.org/MPL/1.0/"),
    MPL11("mpl11", "Mozilla Public License", new Version(1, 1), "https://www.mozilla.org/MPL/1.1/"),
    MPL20("mpl20", "Mozilla Public License", new Version(2, 0), "https://www.mozilla.org/MPL/2.0/"),
    BSD("bsd", "BSD 2-Clause License", null, "https://opensource.org/licenses/BSD-2-Clause"),
    BSD3("bsd3", "BSD 3-Clause License", null, "https://opensource.org/licenses/BSD-3-Clause"),
    MIT("mit", "MIT License", null, "https://opensource.org/licenses/MIT"),
    GPL10("gpl10", "GNU General Public License", new Version(1, 0), "https://www.gnu.org/licenses/old-licenses/gpl-1.0"),
    GPL20("gpl20", "GNU General Public License", new Version(2, 0), "https://www.gnu.org/licenses/old-licenses/gpl-2.0"),
    GPL20CP("gpl20cp", "GNU General Public License with Classpath Exception", new Version(2, 0), "https://www.gnu.org/software/classpath/license.html"),
    GPL30("gpl30", "GNU General Public License", new Version(3, 0), "https://www.gnu.org/licenses/gpl-3.0"),
    LGPL20("lgpl20", "GNU Library General Public License", new Version(2, 0), "https://www.gnu.org/licenses/old-licenses/lgpl-2.0.html"),
    LGPL21("lgpl21", "GNU Lesser General Public License", new Version(2, 1), "https://www.gnu.org/licenses/old-licenses/lgpl-2.1.html"),
    LGPL30("lgpl30", "GNU Lesser General Public License", new Version(3, 0), "https://www.gnu.org/licenses/lgpl-3.0.html"),
    AGPL30("agpl30", "GNU Affero General Public License", new Version(3, 0), "https://www.gnu.org/licenses/agpl-3.0"),
    FDL11("fdl11", "GNU Free Documentation License", new Version(1, 1), "https://www.gnu.org/licenses/old-licenses/fdl-1.1"),
    FDL12("fdl12", "GNU Free Documentation License", new Version(1, 2), "https://www.gnu.org/licenses/old-licenses/fdl-1.2"),
    FDL13("fdl13", "GNU Free Documentation License", new Version(1, 3), "https://www.gnu.org/licenses/fdl-1.3"),
    EPL10("epl10", "Eclipse Public License", new Version(1, 0), "https://www.eclipse.org/org/documents/epl-v10.html"),
    EPL20("epl20", "Eclipse Public License", new Version(2, 0), "https://www.eclipse.org/legal/epl-2.0/"),
    EDL10("edl10", "Eclipse Distribution License", new Version(1, 0), "https://www.eclipse.org/org/documents/edl-v10.php"),
    EUPL11("eupl11", "The European Union Public License", new Version(1, 1), "https://joinup.ec.europa.eu/software/page/eupl/licence-eupl"),
    EUPL12("eupl12", "The European Union Public License", new Version(1, 2), "https://joinup.ec.europa.eu/software/page/eupl/licence-eupl"),
    CCBY10("ccby10", "Creative Commons Attributation", new Version(1, 0), "https://creativecommons.org/licenses/by/1.0/"),
    CCBY20("ccby20", "Creative Commons Attributation", new Version(2, 0), "https://creativecommons.org/licenses/by/2.0/"),
    CCBY25("ccby25", "Creative Commons Attributation", new Version(2, 5), "https://creativecommons.org/licenses/by/2.5/"),
    CCBY30("ccby30", "Creative Commons Attributation", new Version(3, 0), "https://creativecommons.org/licenses/by/3.0/"),
    CCBY40("ccby40", "Creative Commons Attributation", new Version(4, 0), "https://creativecommons.org/licenses/by/4.0/"),
    PUBLIC_DOMAIN("pd", "Public Domain", null, null);

    private final String m_sID;
    private final String m_sName;
    private final Version m_aVersion;
    private final String m_sURL;

    private ELicense(@Nullable String string2, @Nullable String string3, Version version, String string4) {
        this.m_sID = string2;
        this.m_sName = string3;
        this.m_aVersion = version;
        this.m_sURL = string4;
    }

    @Override
    @Nonempty
    public @NonNull String getID() {
        return this.m_sID;
    }

    @Override
    @Nonempty
    public @NonNull String getDisplayName() {
        return this.m_sName;
    }

    @Override
    public @Nullable Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    public @Nullable String getURL() {
        return this.m_sURL;
    }

    public static @Nullable ELicense getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(ELicense.class, string);
    }
}

