/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.text;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class TextVariableHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextVariableHelper.class);
    private static final char MASKING_CHAR = '\\';
    private static final char DOLLAR = '$';
    private static final char OPENING_BRACKET = '{';
    private static final char CLOSING_BRACKET = '}';

    private TextVariableHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CheckForSigned
    private static int _nextCharConsiderMasking(@NonNull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnegative char c, @NonNull StringBuilder stringBuilder) {
        boolean bl = false;
        for (int i = n; i < n + n2; ++i) {
            char c2 = cArray[i];
            if (c2 == '\\') {
                boolean bl2 = bl = !bl;
                if (bl) continue;
                stringBuilder.append(c2);
                continue;
            }
            if (c2 == c) {
                if (!bl) return i;
                stringBuilder.append(c2);
            } else {
                stringBuilder.append(c2);
            }
            bl = false;
        }
        return -1;
    }

    @CheckForSigned
    private static int _nextCharConsiderMaskingBalancedBrackets(@NonNull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnegative char c, @Nonnegative char c2, @NonNull StringBuilder stringBuilder) {
        boolean bl = false;
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            char c3 = cArray[i];
            if (c3 == '\\') {
                boolean bl2 = bl = !bl;
                if (bl) continue;
                stringBuilder.append(c3);
                continue;
            }
            if (c3 == c) {
                if (!bl && n3 <= 0) {
                    return i;
                }
                stringBuilder.append(c3);
                --n3;
            } else {
                if (c3 == c2) {
                    ++n3;
                }
                stringBuilder.append(c3);
            }
            bl = false;
        }
        return -1;
    }

    @CheckForSigned
    private static int _findStartOfVarName(@NonNull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @NonNull StringBuilder stringBuilder) {
        int n3 = n;
        int n4 = TextVariableHelper._nextCharConsiderMasking(cArray, n, n2, '$', stringBuilder);
        while (n4 >= n && n4 <= n + n2 - 1) {
            boolean bl;
            boolean bl2 = bl = n4 == n + n2 - 1;
            if (!bl && cArray[n4 + 1] == '{') {
                return n4 + 2;
            }
            stringBuilder.append('$');
            if (bl) {
                return -1;
            }
            n4 = TextVariableHelper._nextCharConsiderMasking(cArray, n4 + 1, n2 - (n4 - n3 + 1), '$', stringBuilder);
        }
        return n4;
    }

    static @NonNull List<String> splitByVariables(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty(string, "Text");
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(n);
        int n3 = TextVariableHelper._findStartOfVarName(cArray, n2, n - n2, stringBuilder);
        while (n3 >= 0) {
            arrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
            int n4 = TextVariableHelper._nextCharConsiderMaskingBalancedBrackets(cArray, n3, n - n3, '}', '{', stringBuilder);
            if (n4 < 0) {
                LOGGER.warn("End of variable was not found in '" + string + "' starting from ofs " + n3);
                String string2 = string.substring(n3 - 2);
                if (arrayList.size() % 2 == 1) {
                    int n5 = arrayList.size() - 1;
                    arrayList.set(n5, (String)arrayList.get(n5) + string2);
                } else {
                    arrayList.add(string2);
                }
                stringBuilder.setLength(0);
                break;
            }
            arrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
            n2 = n4 + 1;
            n3 = TextVariableHelper._findStartOfVarName(cArray, n2, n - n2, stringBuilder);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static boolean containsVariables(@Nullable String string) {
        return StringHelper.isNotEmpty(string) && TextVariableHelper.splitByVariables(string).size() > 1;
    }

    public static void forEachTextAndVariable(@Nullable String string, @NonNull Consumer<String> consumer, @NonNull Consumer<String> consumer2) {
        ValueEnforcer.notNull(consumer, "TextFragmentHandler");
        ValueEnforcer.notNull(consumer2, "VariableNameHandler");
        if (StringHelper.isEmpty(string)) {
            consumer.accept(string);
        } else {
            List<String> list = TextVariableHelper.splitByVariables(string);
            if (list.size() <= 1) {
                consumer.accept(string);
            } else {
                boolean bl = true;
                for (String string2 : list) {
                    if (StringHelper.isNotEmpty(string2)) {
                        if (bl) {
                            consumer.accept(string2);
                        } else {
                            consumer2.accept(string2);
                        }
                    }
                    bl = !bl;
                }
            }
        }
    }

    public static @Nullable String getWithReplacedVariables(@Nullable String string2, @NonNull UnaryOperator<String> unaryOperator) {
        ValueEnforcer.notNull(unaryOperator, "VariableProvider");
        if (StringHelper.isEmpty(string2)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() * 2);
        TextVariableHelper.forEachTextAndVariable(string2, stringBuilder::append, string -> {
            String string2 = (String)unaryOperator.apply((String)string);
            stringBuilder.append(string2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolved configuration variable '" + string + "' to '" + string2 + "'");
            }
        });
        return stringBuilder.toString();
    }
}

