/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.rt;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.rt.NonBlockingProperties;
import com.helger.base.system.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class PropertiesHelper {
    private PropertiesHelper() {
    }

    @ReturnsMutableCopy
    public static @NonNull Map<String, String> getAsStringMap(@NonNull Properties properties) {
        ValueEnforcer.notNull(properties, "Props");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            hashMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable NonBlockingProperties loadProperties(@WillClose @NonNull InputStream inputStream) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        InputStream inputStream2 = StreamHelper.getBuffered(inputStream);
        try {
            NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
            nonBlockingProperties.load(inputStream2);
            NonBlockingProperties nonBlockingProperties2 = nonBlockingProperties;
            return nonBlockingProperties2;
        }
        catch (IOException iOException) {
            NonBlockingProperties nonBlockingProperties = null;
            return nonBlockingProperties;
        }
        finally {
            StreamHelper.close(inputStream2);
            StreamHelper.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable NonBlockingProperties loadProperties(@WillClose @NonNull Reader reader) {
        ValueEnforcer.notNull(reader, "Reader");
        Reader reader2 = StreamHelper.getBuffered(reader);
        try {
            NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
            nonBlockingProperties.load(reader2);
            NonBlockingProperties nonBlockingProperties2 = nonBlockingProperties;
            return nonBlockingProperties2;
        }
        catch (IOException iOException) {
            NonBlockingProperties nonBlockingProperties = null;
            return nonBlockingProperties;
        }
        finally {
            StreamHelper.close(reader2);
            StreamHelper.close(reader);
        }
    }

    public static @Nullable String expandSystemProperties(@Nullable String string) {
        return PropertiesHelper.expandProperties(string, SystemProperties::getPropertyValue);
    }

    public static @Nullable String expandProperties(@Nullable String string, @NonNull UnaryOperator<String> unaryOperator) {
        ValueEnforcer.notNull(unaryOperator, "ValueProvider");
        if (string == null) {
            return null;
        }
        int n = string.indexOf("${", 0);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = string.length();
        int n3 = 0;
        while (n < n2) {
            int n4;
            if (n > n3) {
                stringBuilder.append(string.substring(n3, n));
            }
            if ((n4 = n + 2) < n2 && string.charAt(n4) == '{') {
                if ((n4 = string.indexOf("}}", n4)) == -1 || n4 + 2 == n2) {
                    stringBuilder.append(string.substring(n));
                    break;
                }
                stringBuilder.append(string.substring(n, ++n4 + 1));
            } else {
                while (n4 < n2 && string.charAt(n4) != '}') {
                    ++n4;
                }
                if (n4 == n2) {
                    stringBuilder.append(string.substring(n, n4));
                    break;
                }
                String string2 = string.substring(n + 2, n4);
                if (string2.equals("/")) {
                    stringBuilder.append(File.separatorChar);
                } else {
                    String string3 = (String)unaryOperator.apply(string2);
                    if (string3 == null) {
                        return string;
                    }
                    stringBuilder.append(string3);
                }
            }
            if ((n = string.indexOf("${", n3 = n4 + 1)) != -1) continue;
            if (n3 >= n2) break;
            stringBuilder.append(string.substring(n3, n2));
            break;
        }
        return stringBuilder.toString();
    }
}

