/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.numeric.BigHelper;
import java.math.RoundingMode;
import org.jspecify.annotations.NonNull;

@Immutable
public final class MathHelper {
    private static final long LONG_HIGH_BITS = Integer.MIN_VALUE;
    private static final MathHelper INSTANCE = new MathHelper();

    private MathHelper() {
    }

    public static int getRoundedUp(int n, @Nonnegative int n2) {
        if (n2 == 0) {
            return n;
        }
        int n3 = n % n2;
        if (n3 == 0) {
            return n;
        }
        if (n < 0) {
            return -MathHelper.abs(n - n3);
        }
        return n + n2 - n3;
    }

    public static double getDividedDouble(int n, int n2) {
        double d = n;
        double d2 = n2;
        return d / d2;
    }

    public static double getDividedDouble(long l, long l2) {
        double d = l;
        double d2 = l2;
        return d / d2;
    }

    public static int getIntDividedCeil(int n, int n2) {
        return MathHelper.getIntDivided(n, n2, RoundingMode.CEILING);
    }

    public static int getIntDividedFloor(int n, int n2) {
        return MathHelper.getIntDivided(n, n2, RoundingMode.FLOOR);
    }

    public static int getIntDivided(int n, int n2, @NonNull RoundingMode roundingMode) {
        return BigHelper.toBigDecimal(n).divide(BigHelper.toBigDecimal(n2), roundingMode).intValue();
    }

    public static long getLongDividedCeil(long l, long l2) {
        return MathHelper.getLongDivided(l, l2, RoundingMode.CEILING);
    }

    public static long getLongDividedFloor(long l, long l2) {
        return MathHelper.getLongDivided(l, l2, RoundingMode.FLOOR);
    }

    public static long getLongDivided(long l, long l2, @NonNull RoundingMode roundingMode) {
        return BigHelper.toBigDecimal(l).divide(BigHelper.toBigDecimal(l2), roundingMode).longValue();
    }

    public static boolean canConvertLongToInt(long l) {
        return (l & Integer.MIN_VALUE) == 0L || (l & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    @CheckReturnValue
    public static int getLongAsInt(long l, int n) {
        return MathHelper.canConvertLongToInt(l) ? (int)l : n;
    }

    public static int getMaxInt(int n, int ... nArray) {
        int n2 = n;
        for (int n3 : nArray) {
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    public static long getMaxLong(long l, long ... lArray) {
        long l2 = l;
        for (long l3 : lArray) {
            l2 = Math.max(l2, l3);
        }
        return l2;
    }

    public static double getMaxFloat(float f, float ... fArray) {
        float f2 = f;
        for (float f3 : fArray) {
            f2 = Math.max(f2, f3);
        }
        return f2;
    }

    public static double getMaxDouble(double d, double ... dArray) {
        double d2 = d;
        for (double d3 : dArray) {
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    public static int getMinInt(int n, int ... nArray) {
        int n2 = n;
        for (int n3 : nArray) {
            n2 = Math.min(n2, n3);
        }
        return n2;
    }

    public static long getMinLong(long l, long ... lArray) {
        long l2 = l;
        for (long l3 : lArray) {
            l2 = Math.min(l2, l3);
        }
        return l2;
    }

    public static double getMinFloat(float f, float ... fArray) {
        float f2 = f;
        for (float f3 : fArray) {
            f2 = Math.min(f2, f3);
        }
        return f2;
    }

    public static double getMinDouble(double d, double ... dArray) {
        double d2 = d;
        for (double d3 : dArray) {
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    @Nonnegative
    public static int abs(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Integer.MIN_VALUE!");
        }
        return Math.abs(n);
    }

    @Nonnegative
    public static long abs(long l) {
        if (l == Long.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Long.MIN_VALUE!");
        }
        return Math.abs(l);
    }

    @Nonnegative
    public static float abs(float f) {
        return Math.abs(f);
    }

    @Nonnegative
    public static double abs(double d) {
        return Math.abs(d);
    }

    public static double hypot(double d, double d2) {
        double d3;
        double d4;
        if (d == 0.0) {
            return d2;
        }
        if (d2 == 0.0) {
            return d;
        }
        double d5 = MathHelper.abs(d);
        if (d5 > (d4 = MathHelper.abs(d2))) {
            d3 = d2 / d;
            d3 = d5 * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = d / d2;
            d3 = d4 * Math.sqrt(1.0 + d3 * d3);
        }
        return d3;
    }

    public static long getUnsignedInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static boolean isExactlyOneBitSetToOne(int n) {
        return n != 0 && (n & n - 1) == 0;
    }

    public static boolean isExactlyOneBitSetToOne(long l) {
        return l != 0L && (l & l - 1L) == 0L;
    }
}

