/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.rt.ByteBufferHelper;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public final class MultiByteBufferInputStream
extends InputStream {
    private ByteBuffer[] m_aBuffers;
    private int m_nBufferIndex = 0;
    private int m_nMarkedBufferIndex = -1;

    public MultiByteBufferInputStream(ByteBuffer ... byteBufferArray) {
        ValueEnforcer.notEmpty(byteBufferArray, "Buffers");
        this.m_aBuffers = ArrayHelper.getCopy(byteBufferArray);
    }

    public boolean isClosed() {
        return this.m_aBuffers == null;
    }

    private void _checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("ByteBuffers are already closed");
        }
    }

    @ReturnsMutableCopy
    public @NonNull ByteBuffer[] getAllBuffers() {
        this._checkClosed();
        return ArrayHelper.getCopy(this.m_aBuffers);
    }

    public boolean isAnythingAvailable() {
        this._checkClosed();
        for (int i = this.m_aBuffers.length - 1; i >= this.m_nBufferIndex; --i) {
            if (!this.m_aBuffers[i].hasRemaining()) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public long getAvailable() {
        this._checkClosed();
        long l = 0L;
        for (int i = this.m_aBuffers.length - 1; i >= this.m_nBufferIndex; --i) {
            l += (long)this.m_aBuffers[i].remaining();
        }
        return l;
    }

    @Override
    @Nonnegative
    public int available() {
        long l = this.getAvailable();
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException("Value does not fit in an int: " + l);
        }
        return (int)l;
    }

    @Override
    public void close() {
        this.m_nBufferIndex = 0;
        this.m_nMarkedBufferIndex = -1;
        this.m_aBuffers = null;
    }

    @Override
    public void mark(int n) {
        this._checkClosed();
        if (this.m_nBufferIndex < this.m_aBuffers.length) {
            this.m_nMarkedBufferIndex = this.m_nBufferIndex;
            for (int i = this.m_aBuffers.length - 1; i >= this.m_nMarkedBufferIndex; --i) {
                this.m_aBuffers[i].mark();
            }
        }
    }

    @Override
    public void reset() {
        this._checkClosed();
        if (this.m_nMarkedBufferIndex != -1) {
            this.m_nBufferIndex = this.m_nMarkedBufferIndex;
            for (int i = this.m_aBuffers.length - 1; i >= this.m_nBufferIndex; --i) {
                this.m_aBuffers[i].reset();
            }
            this.m_nMarkedBufferIndex = -1;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        this._checkClosed();
        while (this.m_nBufferIndex < this.m_aBuffers.length) {
            ByteBuffer byteBuffer = this.m_aBuffers[this.m_nBufferIndex];
            if (byteBuffer.hasRemaining()) {
                return byteBuffer.get() & 0xFF;
            }
            ++this.m_nBufferIndex;
        }
        return -1;
    }

    @Override
    public int read(@NonNull byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(@NonNull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this._checkClosed();
        if (this.m_nBufferIndex >= this.m_aBuffers.length) {
            return -1;
        }
        if (this.m_nBufferIndex == this.m_aBuffers.length - 1 && !this.m_aBuffers[this.m_nBufferIndex].hasRemaining()) {
            return -1;
        }
        if (n2 == 0 || byArray.length == 0) {
            return this.isAnythingAvailable() ? 0 : -1;
        }
        int n3 = 0;
        while (this.m_nBufferIndex < this.m_aBuffers.length) {
            ByteBuffer byteBuffer = this.m_aBuffers[this.m_nBufferIndex];
            int n4 = Math.min(byteBuffer.remaining(), n2 - n3);
            byteBuffer.get(byArray, n + n3, n4);
            if ((n3 += n4) == n2) break;
            ++this.m_nBufferIndex;
        }
        return n3 > 0 ? n3 : -1;
    }

    @Override
    @Nonnegative
    public long skip(long l) {
        this._checkClosed();
        long l2 = 0L;
        while (this.m_nBufferIndex < this.m_aBuffers.length) {
            ByteBuffer byteBuffer = this.m_aBuffers[this.m_nBufferIndex];
            long l3 = Math.min((long)byteBuffer.remaining(), l - l2);
            byteBuffer.position(byteBuffer.position() + (int)l3);
            if ((l2 += l3) == l) break;
            ++this.m_nBufferIndex;
        }
        return l2;
    }

    @Nonnegative
    public long read(@NonNull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(byteBuffer, "DestByteBuffer");
        this._checkClosed();
        long l = 0L;
        while (this.m_nBufferIndex < this.m_aBuffers.length) {
            ByteBuffer byteBuffer2 = this.m_aBuffers[this.m_nBufferIndex];
            if (byteBuffer2.hasRemaining()) {
                l += (long)ByteBufferHelper.transfer(byteBuffer2, byteBuffer, false);
            }
            if (!byteBuffer.hasRemaining()) break;
            ++this.m_nBufferIndex;
        }
        return l;
    }
}

