/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.rt.ByteBufferHelper;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public final class ByteBufferInputStream
extends InputStream {
    private ByteBuffer m_aBuffer;

    public ByteBufferInputStream(@NonNull ByteBuffer byteBuffer) {
        this.m_aBuffer = ValueEnforcer.notNull(byteBuffer, "Buffer");
    }

    public boolean isClosed() {
        return this.m_aBuffer == null;
    }

    private void _checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("ByteBuffer is already closed");
        }
    }

    public @Nullable ByteBuffer getBuffer() {
        this._checkClosed();
        return this.m_aBuffer;
    }

    public boolean isAnythingAvailable() {
        this._checkClosed();
        return this.m_aBuffer.hasRemaining();
    }

    @Override
    @Nonnegative
    public int available() {
        this._checkClosed();
        return this.m_aBuffer.remaining();
    }

    @Override
    public void close() {
        this.m_aBuffer = null;
    }

    @Override
    public void mark(int n) {
        this._checkClosed();
        this.m_aBuffer.mark();
    }

    @Override
    public void reset() {
        this._checkClosed();
        this.m_aBuffer.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.m_aBuffer.hasRemaining()) {
            return this.m_aBuffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(@NonNull byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(@NonNull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        if (!this.m_aBuffer.hasRemaining()) {
            return -1;
        }
        if (n2 == 0 || byArray.length == 0) {
            return this.isAnythingAvailable() ? 0 : -1;
        }
        int n3 = Math.min(this.m_aBuffer.remaining(), n2);
        this.m_aBuffer.get(byArray, n, n3);
        return n3;
    }

    @Override
    @Nonnegative
    public long skip(long l) {
        long l2 = Math.min((long)this.m_aBuffer.remaining(), l);
        this.m_aBuffer.position(this.m_aBuffer.position() + (int)l2);
        return l2;
    }

    @Nonnegative
    public long read(@NonNull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(byteBuffer, "DestByteBuffer");
        long l = 0L;
        if (this.m_aBuffer.hasRemaining()) {
            l += (long)ByteBufferHelper.transfer(this.m_aBuffer, byteBuffer, false);
        }
        return l;
    }
}

