/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.dimension;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.dimension.IHasDimensionFloat;
import com.helger.base.dimension.IHasDimensionInt;
import com.helger.base.dimension.IHasDimensionLong;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@Immutable
public class SizeFloat
implements IHasDimensionFloat {
    private final float m_dWidth;
    private final float m_dHeight;

    public SizeFloat(@NonNull IHasDimensionInt iHasDimensionInt) {
        this(iHasDimensionInt.getWidth(), iHasDimensionInt.getHeight());
    }

    public SizeFloat(@NonNull IHasDimensionLong iHasDimensionLong) {
        this(iHasDimensionLong.getWidth(), iHasDimensionLong.getHeight());
    }

    public SizeFloat(@NonNull IHasDimensionFloat iHasDimensionFloat) {
        this(iHasDimensionFloat.getWidth(), iHasDimensionFloat.getHeight());
    }

    public SizeFloat(@Nonnegative float f, @Nonnegative float f2) {
        this.m_dWidth = ValueEnforcer.isGE0(f, "Width");
        this.m_dHeight = ValueEnforcer.isGE0(f2, "Height");
    }

    @Override
    @Nonnegative
    public float getWidth() {
        return this.m_dWidth;
    }

    @Override
    @Nonnegative
    public float getHeight() {
        return this.m_dHeight;
    }

    @CheckReturnValue
    public @NonNull SizeFloat getBestMatchingSize(@Nonnegative float f, @Nonnegative float f2) {
        ValueEnforcer.isGT0(f, "MaxWidth");
        ValueEnforcer.isGT0(f2, "MaxHeight");
        float f3 = this.m_dWidth / f;
        float f4 = this.m_dHeight / f2;
        if (f3 > f4) {
            if (this.m_dWidth > f) {
                return new SizeFloat(f, this.m_dHeight / f3);
            }
        } else if (this.m_dHeight > f2) {
            return new SizeFloat(this.m_dWidth / f4, f2);
        }
        return this;
    }

    @CheckReturnValue
    public @NonNull SizeFloat getScaledToWidth(@Nonnegative float f) {
        ValueEnforcer.isGT0(f, "NewWidth");
        if (this.m_dWidth == f) {
            return this;
        }
        float f2 = f / this.m_dWidth;
        return new SizeFloat(f, this.m_dHeight * f2);
    }

    @CheckReturnValue
    public @NonNull SizeFloat getScaledToHeight(@Nonnegative float f) {
        ValueEnforcer.isGT0(f, "NewHeight");
        if (this.m_dHeight == f) {
            return this;
        }
        float f2 = f / this.m_dHeight;
        return new SizeFloat(this.m_dWidth * f2, f);
    }

    @CheckReturnValue
    public @NonNull SizeFloat getAdded(@NonNull IHasDimensionInt iHasDimensionInt) {
        ValueEnforcer.notNull(iHasDimensionInt, "ToAdd");
        return new SizeFloat(this.m_dWidth + (float)iHasDimensionInt.getWidth(), this.m_dHeight + (float)iHasDimensionInt.getHeight());
    }

    @CheckReturnValue
    public @NonNull SizeFloat getAdded(@NonNull IHasDimensionFloat iHasDimensionFloat) {
        ValueEnforcer.notNull(iHasDimensionFloat, "ToAdd");
        return new SizeFloat(this.m_dWidth + iHasDimensionFloat.getWidth(), this.m_dHeight + iHasDimensionFloat.getHeight());
    }

    @CheckReturnValue
    public @NonNull SizeFloat getSubtracted(@NonNull IHasDimensionInt iHasDimensionInt) {
        ValueEnforcer.notNull(iHasDimensionInt, "ToSubtract");
        return new SizeFloat(this.m_dWidth - (float)iHasDimensionInt.getWidth(), this.m_dHeight - (float)iHasDimensionInt.getHeight());
    }

    @CheckReturnValue
    public @NonNull SizeFloat getSubtracted(@NonNull IHasDimensionFloat iHasDimensionFloat) {
        ValueEnforcer.notNull(iHasDimensionFloat, "ToSubtract");
        return new SizeFloat(this.m_dWidth - iHasDimensionFloat.getWidth(), this.m_dHeight - iHasDimensionFloat.getHeight());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SizeFloat sizeFloat = (SizeFloat)object;
        return EqualsHelper.equals(this.m_dWidth, sizeFloat.m_dWidth) && EqualsHelper.equals(this.m_dHeight, sizeFloat.m_dHeight);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_dWidth).append(this.m_dHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("width", this.m_dWidth).append("height", this.m_dHeight).getToString();
    }
}

