/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.concurrent;

import com.helger.base.builder.IResettableBuilder;
import com.helger.base.concurrent.BasicThreadFactory;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import java.util.concurrent.ThreadFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BasicThreadFactoryBuilder
implements IResettableBuilder<BasicThreadFactory> {
    ThreadFactory m_aWrappedFactory;
    ThreadGroup m_aThreadGroup;
    Thread.UncaughtExceptionHandler m_aUncaughtExceptionHandler = BasicThreadFactory.s_aDefaultUncaughtExceptionHandler;
    String m_sNamingPattern;
    Integer m_nPriority;
    ETriState m_eDaemon = ETriState.UNDEFINED;

    public final @NonNull BasicThreadFactoryBuilder wrappedFactory(@NonNull ThreadFactory threadFactory) {
        ValueEnforcer.notNull(threadFactory, "Factory");
        this.m_aWrappedFactory = threadFactory;
        return this;
    }

    public final @NonNull BasicThreadFactoryBuilder threadGroup(@Nullable ThreadGroup threadGroup) {
        this.m_aThreadGroup = threadGroup;
        return this;
    }

    public final @NonNull BasicThreadFactoryBuilder uncaughtExceptionHandler( @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        ValueEnforcer.notNull(uncaughtExceptionHandler, "ExceptionHandler");
        this.m_aUncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public final @NonNull BasicThreadFactoryBuilder namingPattern(@NonNull String string) {
        ValueEnforcer.notNull(string, "NamingPattern");
        this.m_sNamingPattern = string;
        return this;
    }

    public final @NonNull BasicThreadFactoryBuilder priority(int n) {
        this.m_nPriority = n;
        return this;
    }

    public final @NonNull BasicThreadFactoryBuilder daemon(boolean bl) {
        this.m_eDaemon = ETriState.valueOf(bl);
        return this;
    }

    @Override
    public void reset() {
        this.m_aWrappedFactory = null;
        this.m_aThreadGroup = null;
        this.m_aUncaughtExceptionHandler = null;
        this.m_sNamingPattern = null;
        this.m_nPriority = null;
        this.m_eDaemon = null;
    }

    @Override
    public @NonNull BasicThreadFactory build() {
        return new BasicThreadFactory(this);
    }
}

