/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.compare;

import com.helger.annotation.Nonnegative;
import com.helger.base.compare.ISortOrderIndicator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum ESortOrder implements ISortOrderIndicator
{
    ASCENDING(1),
    DESCENDING(0);

    public static final ESortOrder DEFAULT;
    private final int m_nValue;

    private ESortOrder(int n2) {
        this.m_nValue = n2;
    }

    @Nonnegative
    public int getValue() {
        return this.m_nValue;
    }

    public @NonNull String getValueAsString() {
        return Integer.toString(this.m_nValue);
    }

    @Override
    public boolean isAscending() {
        return this == ASCENDING;
    }

    public @NonNull ESortOrder getAlternate() {
        return this.isAscending() ? DESCENDING : ASCENDING;
    }

    public static @NonNull ESortOrder getFromValueOrDefault(int n) {
        return ESortOrder.getFromValue(n, DEFAULT);
    }

    public static @Nullable ESortOrder getFromValue(int n, @Nullable ESortOrder eSortOrder) {
        if (n == ESortOrder.ASCENDING.m_nValue) {
            return ASCENDING;
        }
        if (n == ESortOrder.DESCENDING.m_nValue) {
            return DESCENDING;
        }
        return eSortOrder;
    }

    static {
        DEFAULT = ASCENDING;
    }
}

