/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.base.codec.DecodeException;
import com.helger.base.codec.EncodeException;
import com.helger.base.codec.IByteArrayCodec;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.string.StringHex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class Base16Codec
implements IByteArrayCodec {
    @Override
    @Nonnegative
    public int getMaximumEncodedLength(@Nonnegative int n) {
        return n * 2;
    }

    public void encode(@WillNotClose @NonNull InputStream inputStream, @WillNotClose @NonNull OutputStream outputStream) {
        ValueEnforcer.notNull(inputStream, "DecodedInputStream");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                outputStream.write(StringHex.getHexChar((n & 0xF0) >> 4));
                outputStream.write(StringHex.getHexChar(n & 0xF));
            }
        }
        catch (IOException iOException) {
            throw new EncodeException("Failed to encode Base16", iOException);
        }
    }

    @Override
    public void encode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @WillNotClose @NonNull OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray, n, n2, false);){
            this.encode(nonBlockingByteArrayInputStream, outputStream);
        }
    }

    @Override
    @Nonnegative
    public int getMaximumDecodedLength(@Nonnegative int n) {
        return n / 2;
    }

    public void decode(@WillNotClose @NonNull InputStream inputStream, @WillNotClose @NonNull OutputStream outputStream) {
        ValueEnforcer.notNull(inputStream, "EncodedInputStream");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        try {
            int n;
            long l = 0L;
            while ((n = inputStream.read()) != -1) {
                ++l;
                char c = (char)(n & 0xFF);
                n = inputStream.read();
                if (n < 0) {
                    throw new DecodeException("Invalid Base16 encoding. Premature end of input after " + l + " byte(s)");
                }
                ++l;
                char c2 = (char)(n & 0xFF);
                int n2 = StringHex.getHexByte(c, c2);
                if (n2 < 0) {
                    throw new DecodeException("Invalid Base16 encoding for " + c + " and " + c2 + " after " + l + " byte(s)");
                }
                outputStream.write(n2);
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to decode Base16", iOException);
        }
    }

    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @WillNotClose @NonNull OutputStream outputStream) {
        if (byArray == null) {
            return;
        }
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray, n, n2, false);){
            this.decode(nonBlockingByteArrayInputStream, outputStream);
        }
    }
}

