/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.string;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class StringRemove {
    private StringRemove() {
    }

    @Nullable
    public static String removeAll(@Nullable String string, char c) {
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        int n = string.indexOf(c, 0);
        if (n == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(cArray, 0, n);
        for (int i = n; i < n2; ++i) {
            char c2 = cArray[i];
            if (c2 == c) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String removeAll(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        int n = StringHelper.getLength(string2);
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            return StringRemove.removeAll(string, string2.charAt(0));
        }
        int n2 = string.indexOf(string2, 0);
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n3 = 0;
        do {
            stringBuilder.append(string, n3, n2);
        } while ((n2 = string.indexOf(string2, n3 = n2 + n)) != -1);
        stringBuilder.append(string, n3, string.length());
        return stringBuilder.toString();
    }

    @Nonnull
    public static String removeMultiple(@Nullable String string, @Nonnull char[] cArray) {
        ValueEnforcer.notNull(cArray, "RemoveChars");
        if (StringHelper.isEmpty(string)) {
            return "";
        }
        if (cArray.length == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringHelper.iterateChars(string, c -> {
            if (!ArrayHelper.contains(cArray, c)) {
                stringBuilder.append(c);
            }
        });
        return stringBuilder.toString();
    }
}

