/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.streamprovider;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.bytes.ByteArrayWrapper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasByteArray;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;

public class ByteArrayInputStreamProvider
implements IHasByteArray {
    public static final boolean DEFAULT_COPY_NEEDED = false;
    private final ByteArrayWrapper m_aBytes;

    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray) {
        this(byArray, 0, byArray.length, false);
    }

    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(byArray, n, n2, false);
    }

    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aBytes = new ByteArrayWrapper(byArray, n, n2, bl);
    }

    @Override
    public final boolean isCopy() {
        return this.m_aBytes.isCopy();
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final byte[] bytes() {
        return this.m_aBytes.bytes();
    }

    @Override
    @Nonnegative
    public final int getOffset() {
        return this.m_aBytes.getOffset();
    }

    @Override
    @Nonnegative
    public final int size() {
        return this.m_aBytes.size();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Bytes", this.m_aBytes).getToString();
    }
}

