/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.lang;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.system.ENewLineMode;
import com.helger.base.system.SystemProperties;
import jakarta.annotation.Nonnull;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@Immutable
public final class ClassPathHelper {
    private static final ClassPathHelper INSTANCE = new ClassPathHelper();

    private ClassPathHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getAllClassPathEntries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassPathHelper.forAllClassPathEntries(arrayList::add);
        return arrayList;
    }

    public static void forAllClassPathEntries(@Nonnull Consumer<? super String> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        StringHelper.explode(SystemProperties.getPathSeparator(), SystemProperties.getJavaClassPath(), consumer);
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream) {
        ClassPathHelper.printClassPathEntries(printStream, ENewLineMode.DEFAULT.getText());
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream, @Nonnull String string) {
        ClassPathHelper.forAllClassPathEntries(string2 -> {
            printStream.print((String)string2);
            printStream.print(string);
        });
    }
}

