/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.id.factory;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.id.factory.IIntIDFactory;
import com.helger.base.tostring.ToStringGenerator;
import java.util.concurrent.atomic.AtomicInteger;

@ThreadSafe
public final class MemoryIntIDFactory
implements IIntIDFactory {
    public static final int DEFAULT_START_ID = 10000;
    private final AtomicInteger m_aID;

    public MemoryIntIDFactory() {
        this(10000);
    }

    public MemoryIntIDFactory(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "StartID");
        this.m_aID = new AtomicInteger(n);
    }

    @Override
    public int getNewID() {
        return this.m_aID.getAndIncrement();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MemoryIntIDFactory memoryIntIDFactory = (MemoryIntIDFactory)object;
        return this.m_aID.get() == memoryIntIDFactory.m_aID.get();
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aID.get()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_aID).getToString();
    }
}

