/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.concurrent;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

@Immutable
@ThreadSafe
public final class ThreadHelper {
    private ThreadHelper() {
    }

    @Nonnull
    public static ESuccess sleepMinutes(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "Minutes");
        return ThreadHelper.sleep(l * 60000L);
    }

    @Nonnull
    public static ESuccess sleepSeconds(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "Seconds");
        return ThreadHelper.sleep(l * 1000L);
    }

    @Nonnull
    public static ESuccess sleep(@Nonnull Duration duration) {
        ValueEnforcer.notNull(duration, "Duration");
        return ThreadHelper.sleep(duration.toMillis());
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        ValueEnforcer.isGE0(l, "Duration");
        ValueEnforcer.notNull(timeUnit, "TimeUnit");
        return ThreadHelper.sleep(timeUnit.toMillis(l));
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long l) {
        ValueEnforcer.isGE0(l, "MilliSeconds");
        try {
            Thread.sleep(l);
            return ESuccess.SUCCESS;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return ESuccess.FAILURE;
        }
    }
}

