/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.callback.exception;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.callback.exception.IExceptionCallback;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

@NotThreadSafe
public class CollectingExceptionListCallback<EXTYPE extends Throwable>
implements IExceptionCallback<EXTYPE> {
    private final List<EXTYPE> m_aExceptions = new ArrayList<EXTYPE>();

    @Override
    public void onException(@Nullable EXTYPE EXTYPE) {
        if (EXTYPE != null) {
            this.m_aExceptions.add(EXTYPE);
        }
    }

    public boolean hasException() {
        return !this.m_aExceptions.isEmpty();
    }

    @Nonnegative
    public int getExceptionCount() {
        return this.m_aExceptions.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<EXTYPE> getAllExceptions() {
        return new ArrayList<EXTYPE>(this.m_aExceptions);
    }

    public String toString() {
        return new ToStringGenerator(this).append("Exceptions", this.m_aExceptions).getToString();
    }
}

