/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.text;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.MessageFormat;
import java.util.Locale;

@Immutable
public final class TextFormatter {
    private TextFormatter() {
    }

    @Nullable
    public static String getFormattedText(@Nullable String string, Object ... objectArray) {
        if (string == null) {
            return null;
        }
        if (ArrayHelper.isEmpty(objectArray)) {
            return string;
        }
        MessageFormat messageFormat = new MessageFormat(string, Locale.getDefault(Locale.Category.FORMAT));
        return messageFormat.format(objectArray);
    }

    @Nullable
    public static String getFormattedText(@Nonnull Locale locale, @Nullable String string, Object ... objectArray) {
        ValueEnforcer.notNull(locale, "DisplayLocale");
        if (string == null) {
            return null;
        }
        if (ArrayHelper.isEmpty(objectArray)) {
            return string;
        }
        MessageFormat messageFormat = new MessageFormat(string, locale);
        return messageFormat.format(objectArray);
    }
}

