/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.email;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.email.EmailAddressHelper;
import com.helger.base.email.IEmailAddress;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public class EmailAddress
implements IEmailAddress {
    private final String m_sAddress;
    private final String m_sPersonal;

    public EmailAddress(@Nonnull IEmailAddress iEmailAddress) {
        this(iEmailAddress.getAddress(), iEmailAddress.getPersonal());
    }

    public EmailAddress(@Nonnull String string) {
        this(string, null);
    }

    public EmailAddress(@Nonnull String string, @Nullable String string2) {
        ValueEnforcer.notNull(string, "EmailAddress");
        ValueEnforcer.isTrue(EmailAddressHelper.isValid(string), () -> "The passed email address '" + string + "' is illegal!");
        this.m_sAddress = EmailAddressHelper.getUnifiedEmailAddress(string);
        this.m_sPersonal = StringHelper.isEmpty(string2) ? null : string2;
    }

    @Override
    @Nonnull
    public String getAddress() {
        return this.m_sAddress;
    }

    @Override
    @Nullable
    public String getPersonal() {
        return this.m_sPersonal;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailAddress emailAddress = (EmailAddress)object;
        return this.m_sAddress.equals(emailAddress.m_sAddress) && EqualsHelper.equals(this.m_sPersonal, emailAddress.m_sPersonal);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sAddress).append(this.m_sPersonal).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Address", this.m_sAddress).appendIfNotNull("Personal", this.m_sPersonal).getToString();
    }

    @Nullable
    public static EmailAddress createOnDemand(@Nullable String string) {
        return StringHelper.isEmpty(string) ? null : new EmailAddress(string);
    }

    @Nullable
    public static EmailAddress createOnDemand(@Nullable String string, @Nullable String string2) {
        return StringHelper.isEmpty(string) ? null : new EmailAddress(string, string2);
    }
}

