/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.wrapper;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.wrapper.IMutableWrapper;
import com.helger.base.wrapper.IWrapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class Wrapper<DATATYPE>
implements IMutableWrapper<DATATYPE>,
ICloneable<Wrapper<DATATYPE>> {
    private DATATYPE m_aObj;

    public Wrapper() {
    }

    public Wrapper(@Nullable DATATYPE DATATYPE) {
        this.m_aObj = DATATYPE;
    }

    public Wrapper(@Nonnull IWrapper<DATATYPE> iWrapper) {
        this.m_aObj = ValueEnforcer.notNull(iWrapper, "Wrapper").get();
    }

    @Override
    @Nullable
    public DATATYPE get() {
        return this.m_aObj;
    }

    @Override
    @Nonnull
    public EChange set(@Nullable DATATYPE DATATYPE) {
        if (EqualsHelper.equals(this.m_aObj, DATATYPE)) {
            return EChange.UNCHANGED;
        }
        this.m_aObj = DATATYPE;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Wrapper<DATATYPE> getClone() {
        return new Wrapper<DATATYPE>(this.m_aObj);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Wrapper wrapper = (Wrapper)object;
        return EqualsHelper.equals(this.m_aObj, wrapper.m_aObj);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aObj).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Obj", this.m_aObj).getToString();
    }
}

