/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.equals;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.function.BiPredicate;

public class EqualsHelper {
    protected EqualsHelper() {
    }

    public static <T> boolean identityEqual(@Nullable T t, @Nullable T t2) {
        return t == t2;
    }

    public static <T> boolean identityDifferent(@Nullable T t, @Nullable T t2) {
        return t != t2;
    }

    public static boolean equals(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static boolean equals(byte by, byte by2) {
        return by == by2;
    }

    public static boolean equals(char c, char c2) {
        return c == c2;
    }

    public static boolean equals(double d, double d2) {
        return d == d2 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean equals(float f, float f2) {
        return f == f2 || Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean equals(int n, int n2) {
        return n == n2;
    }

    public static boolean equals(long l, long l2) {
        return l == l2;
    }

    public static boolean equals(short s, short s2) {
        return s == s2;
    }

    public static boolean equals(@Nullable Object object, @Nullable Object object2) {
        return Objects.deepEquals(object, object2);
    }

    public static boolean equalsIgnoreCase(@Nullable String string, @Nullable String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static <T> boolean equalsCustom(@Nullable T t, @Nullable T t2, @Nonnull BiPredicate<T, T> biPredicate) {
        Objects.requireNonNull(biPredicate, "Predicate");
        if (EqualsHelper.identityEqual(t, t2)) {
            return true;
        }
        if (t == null || t2 == null) {
            return false;
        }
        return biPredicate.test(t, t2);
    }
}

