/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.email;

import com.helger.annotation.concurrent.Immutable;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.regex.Pattern;

@Immutable
public final class EmailAddressHelper {
    public static final String EMAIL_ADDRESS_PATTERN = "[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
    public static final String EMAIL_ADDRESS_PATTERN_SIMPLE = "[^@\\s]+@([^@.\\s]+\\.)+[^@.\\s]+";
    private static final Pattern PATTERN = Pattern.compile("[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?");
    private static final Pattern PATTERN_SIMPLE = Pattern.compile("[^@\\s]+@([^@.\\s]+\\.)+[^@.\\s]+");

    private EmailAddressHelper() {
    }

    @Nullable
    public static String getUnifiedEmailAddress(@Nullable String string) {
        return string == null ? null : string.trim().toLowerCase(Locale.US);
    }

    public static boolean isValid(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = EmailAddressHelper.getUnifiedEmailAddress(string);
        return PATTERN.matcher(string2).matches();
    }

    public static boolean isValidForSimplePattern(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = EmailAddressHelper.getUnifiedEmailAddress(string);
        return PATTERN_SIMPLE.matcher(string2).matches();
    }
}

