/*
 * Decompiled with CFR 0.152.
 */
package com.helger.annotation;

import com.helger.annotation.meta.TypeQualifierValidator;
import com.helger.annotation.meta.When;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Nonnegative {
    public When when() default When.ALWAYS;

    public static class Checker
    implements TypeQualifierValidator<Nonnegative> {
        @Override
        public When forConstantValue(Nonnegative nonnegative, Object object) {
            boolean bl;
            if (!(object instanceof Number)) {
                return When.NEVER;
            }
            Number number = (Number)object;
            if (number instanceof Long) {
                bl = number.longValue() < 0L;
            } else if (number instanceof Double) {
                bl = number.doubleValue() < 0.0;
            } else if (number instanceof Float) {
                bl = number.floatValue() < 0.0f;
            } else {
                boolean bl2 = bl = number.intValue() < 0;
            }
            if (bl) {
                return When.NEVER;
            }
            return When.ALWAYS;
        }
    }
}

