/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.v4.app.Fragment;
import android.support.v7.view.ContextThemeWrapper;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.heinrichreimersoftware.materialintro.app.ButtonCtaFragment;
import com.heinrichreimersoftware.materialintro.app.SlideFragment;
import com.heinrichreimersoftware.materialintro.slide.ButtonCtaSlide;
import com.heinrichreimersoftware.materialintro.slide.RestorableSlide;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import com.heinrichreimersoftware.materialintro.view.parallax.ParallaxFragment;

public class FragmentSlide
implements Slide,
RestorableSlide,
ButtonCtaSlide {
    private Fragment fragment;
    @ColorRes
    private final int background;
    @ColorRes
    private final int backgroundDark;
    private final boolean canGoForward;
    private final boolean canGoBackward;
    private CharSequence buttonCtaLabel = null;
    @StringRes
    private int buttonCtaLabelRes = 0;
    private View.OnClickListener buttonCtaClickListener = null;

    protected FragmentSlide(Builder builder) {
        this.fragment = builder.fragment;
        this.background = builder.background;
        this.backgroundDark = builder.backgroundDark;
        this.canGoForward = builder.canGoForward;
        this.canGoBackward = builder.canGoBackward;
        this.buttonCtaLabel = builder.buttonCtaLabel;
        this.buttonCtaLabelRes = builder.buttonCtaLabelRes;
        this.buttonCtaClickListener = builder.buttonCtaClickListener;
    }

    @Override
    public Fragment getFragment() {
        return this.fragment;
    }

    @Override
    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
    }

    @Override
    public int getBackground() {
        return this.background;
    }

    @Override
    public int getBackgroundDark() {
        return this.backgroundDark;
    }

    @Override
    public boolean canGoForward() {
        if (this.getFragment() instanceof SlideFragment) {
            return ((SlideFragment)this.getFragment()).canGoForward();
        }
        return this.canGoForward;
    }

    @Override
    public boolean canGoBackward() {
        if (this.getFragment() instanceof SlideFragment) {
            return ((SlideFragment)this.getFragment()).canGoBackward();
        }
        return this.canGoBackward;
    }

    @Override
    public View.OnClickListener getButtonCtaClickListener() {
        if (this.getFragment() instanceof ButtonCtaFragment) {
            return ((ButtonCtaFragment)this.getFragment()).getButtonCtaClickListener();
        }
        return this.buttonCtaClickListener;
    }

    @Override
    public CharSequence getButtonCtaLabel() {
        if (this.getFragment() instanceof ButtonCtaFragment) {
            return ((ButtonCtaFragment)this.getFragment()).getButtonCtaLabel();
        }
        return this.buttonCtaLabel;
    }

    @Override
    public int getButtonCtaLabelRes() {
        if (this.getFragment() instanceof ButtonCtaFragment) {
            return ((ButtonCtaFragment)this.getFragment()).getButtonCtaLabelRes();
        }
        return this.buttonCtaLabelRes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentSlide that = (FragmentSlide)o;
        if (this.background != that.background) {
            return false;
        }
        if (this.backgroundDark != that.backgroundDark) {
            return false;
        }
        if (this.canGoForward != that.canGoForward) {
            return false;
        }
        if (this.canGoBackward != that.canGoBackward) {
            return false;
        }
        if (this.buttonCtaLabelRes != that.buttonCtaLabelRes) {
            return false;
        }
        if (this.fragment != null ? !this.fragment.equals((Object)that.fragment) : that.fragment != null) {
            return false;
        }
        if (this.buttonCtaLabel != null ? !this.buttonCtaLabel.equals(that.buttonCtaLabel) : that.buttonCtaLabel != null) {
            return false;
        }
        return this.buttonCtaClickListener != null ? this.buttonCtaClickListener.equals(that.buttonCtaClickListener) : that.buttonCtaClickListener == null;
    }

    public int hashCode() {
        int result = this.fragment != null ? this.fragment.hashCode() : 0;
        result = 31 * result + this.background;
        result = 31 * result + this.backgroundDark;
        result = 31 * result + (this.canGoForward ? 1 : 0);
        result = 31 * result + (this.canGoBackward ? 1 : 0);
        result = 31 * result + (this.buttonCtaLabel != null ? this.buttonCtaLabel.hashCode() : 0);
        result = 31 * result + this.buttonCtaLabelRes;
        result = 31 * result + (this.buttonCtaClickListener != null ? this.buttonCtaClickListener.hashCode() : 0);
        return result;
    }

    public static class FragmentSlideFragment
    extends ParallaxFragment {
        private static final String ARGUMENT_LAYOUT_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_LAYOUT_RES";
        private static final String ARGUMENT_THEME_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_THEME_RES";

        public static FragmentSlideFragment newInstance(@LayoutRes int layoutRes, @StyleRes int themeRes) {
            Bundle arguments = new Bundle();
            arguments.putInt(ARGUMENT_LAYOUT_RES, layoutRes);
            arguments.putInt(ARGUMENT_THEME_RES, themeRes);
            FragmentSlideFragment fragment = new FragmentSlideFragment();
            fragment.setArguments(arguments);
            return fragment;
        }

        public static FragmentSlideFragment newInstance(@LayoutRes int layoutRes) {
            return FragmentSlideFragment.newInstance(layoutRes, 0);
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            int themeRes = this.getArguments().getInt(ARGUMENT_THEME_RES);
            Object contextThemeWrapper = themeRes != 0 ? new ContextThemeWrapper((Context)this.getActivity(), themeRes) : this.getActivity();
            LayoutInflater localInflater = inflater.cloneInContext((Context)contextThemeWrapper);
            return localInflater.inflate(this.getArguments().getInt(ARGUMENT_LAYOUT_RES), container, false);
        }
    }

    public static class Builder {
        private Fragment fragment;
        @ColorRes
        private int background;
        @ColorRes
        private int backgroundDark = 0;
        private boolean canGoForward = true;
        private boolean canGoBackward = true;
        private CharSequence buttonCtaLabel = null;
        @StringRes
        private int buttonCtaLabelRes = 0;
        private View.OnClickListener buttonCtaClickListener = null;

        public Builder fragment(Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public Builder fragment(@LayoutRes int layoutRes, @StyleRes int themeRes) {
            this.fragment = FragmentSlideFragment.newInstance(layoutRes, themeRes);
            return this;
        }

        public Builder fragment(@LayoutRes int layoutRes) {
            this.fragment = FragmentSlideFragment.newInstance(layoutRes);
            return this;
        }

        public Builder background(@ColorRes int background) {
            this.background = background;
            return this;
        }

        public Builder backgroundDark(@ColorRes int backgroundDark) {
            this.backgroundDark = backgroundDark;
            return this;
        }

        public Builder canGoForward(boolean canGoForward) {
            this.canGoForward = canGoForward;
            return this;
        }

        public Builder canGoBackward(boolean canGoBackward) {
            this.canGoBackward = canGoBackward;
            return this;
        }

        public Builder buttonCtaLabel(CharSequence buttonCtaLabel) {
            this.buttonCtaLabel = buttonCtaLabel;
            this.buttonCtaLabelRes = 0;
            return this;
        }

        public Builder buttonCtaLabelHtml(String buttonCtaLabelHtml) {
            this.buttonCtaLabel = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)buttonCtaLabelHtml, (int)0) : Html.fromHtml((String)buttonCtaLabelHtml);
            this.buttonCtaLabelRes = 0;
            return this;
        }

        public Builder buttonCtaLabel(@StringRes int buttonCtaLabelRes) {
            this.buttonCtaLabelRes = buttonCtaLabelRes;
            this.buttonCtaLabel = null;
            return this;
        }

        public Builder buttonCtaClickListener(View.OnClickListener buttonCtaClickListener) {
            this.buttonCtaClickListener = buttonCtaClickListener;
            return this;
        }

        public FragmentSlide build() {
            if (this.background == 0 || this.fragment == null) {
                throw new IllegalArgumentException("You must set at least a fragment and background.");
            }
            return new FragmentSlide(this);
        }
    }
}

