/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.util;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;

public class CheatSheet {
    private static final int ESTIMATED_TOAST_HEIGHT_DIPS = 48;

    public static void setup(View view) {
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return CheatSheet.showCheatSheet(view, view.getContentDescription());
            }
        });
    }

    public static void setup(View view, final int textResId) {
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return CheatSheet.showCheatSheet(view, view.getContext().getString(textResId));
            }
        });
    }

    public static void setup(View view, final CharSequence text) {
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return CheatSheet.showCheatSheet(view, text);
            }
        });
    }

    public static void remove(View view) {
        view.setOnLongClickListener(null);
    }

    private static boolean showCheatSheet(View view, CharSequence text) {
        boolean showBelow;
        if (TextUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        int[] screenPos = new int[2];
        Rect displayFrame = new Rect();
        view.getLocationOnScreen(screenPos);
        view.getWindowVisibleDisplayFrame(displayFrame);
        Context context = view.getContext();
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        int viewCenterX = screenPos[0] + viewWidth / 2;
        int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
        int estimatedToastHeight = (int)(48.0f * context.getResources().getDisplayMetrics().density);
        Toast cheatSheet = Toast.makeText((Context)context, (CharSequence)text, (int)0);
        boolean bl = showBelow = screenPos[1] < estimatedToastHeight;
        if (showBelow) {
            cheatSheet.setGravity(49, viewCenterX - screenWidth / 2, screenPos[1] - displayFrame.top + viewHeight);
        } else {
            cheatSheet.setGravity(49, viewCenterX - screenWidth / 2, screenPos[1] - displayFrame.top - estimatedToastHeight);
        }
        cheatSheet.show();
        return true;
    }
}

