/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.view.parallax;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.FloatRange;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.view.parallax.Parallaxable;

public class ParallaxRelativeLayout
extends RelativeLayout
implements Parallaxable {
    @FloatRange(from=-1.0, to=1.0)
    private float offset = 0.0f;

    public ParallaxRelativeLayout(Context context) {
        super(context);
    }

    public ParallaxRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ParallaxRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    @Override
    public void setOffset(@FloatRange(from=-1.0, to=1.0) float offset) {
        this.offset = offset;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            LayoutParams p = (LayoutParams)child.getLayoutParams();
            if (p.parallaxFactor == 0.0f) continue;
            child.setTranslationX((float)this.getWidth() * -offset * p.parallaxFactor);
        }
    }

    public static class LayoutParams
    extends RelativeLayout.LayoutParams {
        float parallaxFactor = 0.0f;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ParallaxLayout_Layout);
            this.parallaxFactor = a.getFloat(R.styleable.ParallaxLayout_Layout_layout_parallaxFactor, this.parallaxFactor);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }
}

