/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.view;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;

public class SwipeBlockableViewPager
extends ViewPager {
    private static final int SWIPE_DIRECTION_LEFT = 1;
    private static final int SWIPE_DIRECTION_NONE = 0;
    private static final int SWIPE_DIRECTION_RIGHT = -1;
    private static final int SWIPE_THRESHOLD = 0;
    private float initialX;
    private boolean swipeRightEnabled = true;
    private boolean swipeLeftEnabled = true;
    private boolean locked = false;

    public SwipeBlockableViewPager(Context context) {
        super(context);
    }

    public SwipeBlockableViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setSwipeRightEnabled(boolean swipeRightEnabled) {
        this.swipeRightEnabled = swipeRightEnabled;
    }

    public void setSwipeLeftEnabled(boolean swipeLeftEnabled) {
        this.swipeLeftEnabled = swipeLeftEnabled;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.handleTouchEvent(event) && super.onTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.handleTouchEvent(event) && super.onInterceptTouchEvent(event);
    }

    private boolean handleTouchEvent(MotionEvent event) {
        if (this.getSwipeDirection(event) == -1 && !this.swipeRightEnabled) {
            if (!this.locked) {
                this.updatePosition();
                this.locked = true;
            }
            return false;
        }
        if (this.getSwipeDirection(event) == 1 && !this.swipeLeftEnabled) {
            if (!this.locked) {
                this.updatePosition();
                this.locked = true;
            }
            return false;
        }
        this.locked = false;
        return true;
    }

    private void updatePosition() {
        int currentItem = this.getCurrentItem();
        this.scrollTo(currentItem * this.getWidth(), this.getScrollY());
        PagerAdapter adapter = this.getAdapter();
        if (adapter != null) {
            adapter.notifyDataSetChanged();
        }
        this.setCurrentItem(currentItem);
    }

    public int getSwipeDirection(MotionEvent event) {
        if (event.getAction() == 0) {
            this.initialX = event.getX();
            return 0;
        }
        if (event.getAction() == 2 || event.getAction() == 1) {
            float distanceX = event.getX() - this.initialX;
            if (0.0f > Math.abs(distanceX)) {
                return 0;
            }
            if (distanceX > 0.0f) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

