/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.slide.ButtonCtaSlide;
import com.heinrichreimersoftware.materialintro.slide.RestorableSlide;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import com.heinrichreimersoftware.materialintro.view.parallax.ParallaxSlideFragment;
import java.util.ArrayList;

public class SimpleSlide
implements Slide,
RestorableSlide,
ButtonCtaSlide {
    private static final int DEFAULT_PERMISSIONS_REQUEST_CODE = 34;
    private SimpleSlideFragment fragment;
    @ColorRes
    private final int background;
    @ColorRes
    private final int backgroundDark;
    private final boolean canGoForward;
    private final boolean canGoBackward;
    private String[] permissions;
    private int permissionsRequestCode;
    private CharSequence buttonCtaLabel = null;
    @StringRes
    private int buttonCtaLabelRes = 0;
    private View.OnClickListener buttonCtaClickListener = null;

    protected SimpleSlide(Builder builder) {
        this.fragment = SimpleSlideFragment.newInstance(builder.title, builder.titleRes, builder.description, builder.descriptionRes, builder.imageRes, builder.background, builder.layoutRes, builder.permissionsRequestCode);
        this.background = builder.background;
        this.backgroundDark = builder.backgroundDarkRes;
        this.canGoForward = builder.canGoForward;
        this.canGoBackward = builder.canGoBackward;
        this.permissions = builder.permissions;
        this.permissionsRequestCode = builder.permissionsRequestCode;
        this.buttonCtaLabel = builder.buttonCtaLabel;
        this.buttonCtaLabelRes = builder.buttonCtaLabelRes;
        this.buttonCtaClickListener = builder.buttonCtaClickListener;
        this.updatePermissions();
    }

    @Override
    public Fragment getFragment() {
        return this.fragment;
    }

    @Override
    public void setFragment(Fragment fragment) {
        if (fragment instanceof SimpleSlideFragment) {
            this.fragment = (SimpleSlideFragment)fragment;
        }
    }

    @Override
    public int getBackground() {
        return this.background;
    }

    @Override
    public int getBackgroundDark() {
        return this.backgroundDark;
    }

    @Override
    public boolean canGoForward() {
        this.updatePermissions();
        return this.canGoForward && this.permissions == null;
    }

    @Override
    public boolean canGoBackward() {
        return this.canGoBackward;
    }

    @Override
    public View.OnClickListener getButtonCtaClickListener() {
        this.updatePermissions();
        if (this.permissions == null) {
            return this.buttonCtaClickListener;
        }
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (SimpleSlide.this.fragment.getActivity() != null) {
                    ActivityCompat.requestPermissions((Activity)SimpleSlide.this.fragment.getActivity(), (String[])SimpleSlide.this.permissions, (int)SimpleSlide.this.permissionsRequestCode);
                }
            }
        };
    }

    @Override
    public CharSequence getButtonCtaLabel() {
        this.updatePermissions();
        if (this.permissions == null) {
            return this.buttonCtaLabel;
        }
        Context context = this.fragment.getContext();
        if (context != null) {
            return context.getResources().getQuantityText(R.plurals.mi_label_grant_permission, this.permissions.length);
        }
        return null;
    }

    @Override
    public int getButtonCtaLabelRes() {
        this.updatePermissions();
        if (this.permissions == null) {
            return this.buttonCtaLabelRes;
        }
        return 0;
    }

    private synchronized void updatePermissions() {
        if (this.permissions != null) {
            ArrayList<String> permissionsNotGranted = new ArrayList<String>();
            for (String permission : this.permissions) {
                if (this.fragment.getContext() != null && ContextCompat.checkSelfPermission((Context)this.fragment.getContext(), (String)permission) == 0) continue;
                permissionsNotGranted.add(permission);
            }
            this.permissions = permissionsNotGranted.size() > 0 ? permissionsNotGranted.toArray(new String[permissionsNotGranted.size()]) : null;
        } else {
            this.permissions = null;
        }
    }

    public static class SimpleSlideFragment
    extends ParallaxSlideFragment {
        private static final String ARGUMENT_TITLE = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_TITLE";
        private static final String ARGUMENT_TITLE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_TITLE_RES";
        private static final String ARGUMENT_DESCRIPTION = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_DESCRIPTION";
        private static final String ARGUMENT_DESCRIPTION_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_DESCRIPTION_RES";
        private static final String ARGUMENT_IMAGE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_IMAGE_RES";
        private static final String ARGUMENT_BACKGROUND_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_BACKGROUND_RES";
        private static final String ARGUMENT_LAYOUT_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_LAYOUT_RES";
        private static final String ARGUMENT_PERMISSIONS_REQUEST_CODE = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_PERMISSIONS_REQUEST_CODE";

        public static SimpleSlideFragment newInstance(CharSequence title, @StringRes int titleRes, CharSequence description, @StringRes int descriptionRes, @DrawableRes int imageRes, @ColorRes int backgroundRes, @LayoutRes int layout2, int permissionsRequestCode) {
            SimpleSlideFragment fragment = new SimpleSlideFragment();
            Bundle arguments = new Bundle();
            arguments.putCharSequence(ARGUMENT_TITLE, title);
            arguments.putInt(ARGUMENT_TITLE_RES, titleRes);
            arguments.putCharSequence(ARGUMENT_DESCRIPTION, description);
            arguments.putInt(ARGUMENT_DESCRIPTION_RES, descriptionRes);
            arguments.putInt(ARGUMENT_IMAGE_RES, imageRes);
            arguments.putInt(ARGUMENT_BACKGROUND_RES, backgroundRes);
            arguments.putInt(ARGUMENT_LAYOUT_RES, layout2);
            arguments.putInt(ARGUMENT_PERMISSIONS_REQUEST_CODE, permissionsRequestCode);
            fragment.setArguments(arguments);
            return fragment;
        }

        public void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.setRetainInstance(true);
            this.updateNavigation();
        }

        public void onResume() {
            super.onResume();
            this.updateNavigation();
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            int textColorSecondary;
            int textColorPrimary;
            Bundle arguments = this.getArguments();
            View fragment = inflater.inflate(arguments.getInt(ARGUMENT_LAYOUT_RES, R.layout.fragment_simple_slide), container, false);
            TextView titleView = (TextView)fragment.findViewById(R.id.mi_title);
            TextView descriptionView = (TextView)fragment.findViewById(R.id.mi_description);
            ImageView imageView = (ImageView)fragment.findViewById(R.id.mi_image);
            CharSequence title = arguments.getCharSequence(ARGUMENT_TITLE);
            int titleRes = arguments.getInt(ARGUMENT_TITLE_RES);
            CharSequence description = arguments.getCharSequence(ARGUMENT_DESCRIPTION);
            int descriptionRes = arguments.getInt(ARGUMENT_DESCRIPTION_RES);
            int imageRes = arguments.getInt(ARGUMENT_IMAGE_RES);
            int backgroundRes = arguments.getInt(ARGUMENT_BACKGROUND_RES);
            if (titleView != null) {
                if (title != null) {
                    titleView.setText(title);
                    titleView.setVisibility(0);
                } else if (titleRes != 0) {
                    titleView.setText(titleRes);
                    titleView.setVisibility(0);
                } else {
                    titleView.setVisibility(8);
                }
            }
            if (descriptionView != null) {
                if (description != null) {
                    descriptionView.setText(description);
                    descriptionView.setVisibility(0);
                } else if (descriptionRes != 0) {
                    descriptionView.setText(descriptionRes);
                    descriptionView.setVisibility(0);
                } else {
                    descriptionView.setVisibility(8);
                }
            }
            if (imageView != null) {
                if (imageRes != 0) {
                    imageView.setImageResource(imageRes);
                    imageView.setVisibility(0);
                } else {
                    imageView.setVisibility(8);
                }
            }
            if (backgroundRes != 0 && ColorUtils.calculateLuminance((int)ContextCompat.getColor((Context)this.getContext(), (int)backgroundRes)) < 0.6) {
                textColorPrimary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_dark);
                textColorSecondary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_dark);
            } else {
                textColorPrimary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_light);
                textColorSecondary = ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_light);
            }
            if (titleView != null) {
                titleView.setTextColor(textColorPrimary);
            }
            if (descriptionView != null) {
                descriptionView.setTextColor(textColorSecondary);
            }
            return fragment;
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            int permissionsRequestCode;
            int n = permissionsRequestCode = this.getArguments() == null ? 34 : this.getArguments().getInt(ARGUMENT_PERMISSIONS_REQUEST_CODE, 34);
            if (requestCode == permissionsRequestCode) {
                this.updateNavigation();
            }
        }
    }

    public static class Builder {
        @ColorRes
        private int background = 0;
        @ColorRes
        private int backgroundDarkRes = 0;
        private CharSequence title = null;
        @StringRes
        private int titleRes = 0;
        private CharSequence description = null;
        @StringRes
        private int descriptionRes = 0;
        @DrawableRes
        private int imageRes = 0;
        @LayoutRes
        private int layoutRes = R.layout.fragment_simple_slide;
        private boolean canGoForward = true;
        private boolean canGoBackward = true;
        private String[] permissions = null;
        private CharSequence buttonCtaLabel = null;
        @StringRes
        private int buttonCtaLabelRes = 0;
        private View.OnClickListener buttonCtaClickListener = null;
        private int permissionsRequestCode = 34;

        public Builder background(@ColorRes int backgroundRes) {
            this.background = backgroundRes;
            return this;
        }

        public Builder backgroundDark(@ColorRes int backgroundDarkRes) {
            this.backgroundDarkRes = backgroundDarkRes;
            return this;
        }

        public Builder title(CharSequence title) {
            this.title = title;
            this.titleRes = 0;
            return this;
        }

        public Builder titleHtml(String titleHtml) {
            this.title = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)titleHtml, (int)0) : Html.fromHtml((String)titleHtml);
            this.titleRes = 0;
            return this;
        }

        public Builder title(@StringRes int titleRes) {
            this.titleRes = titleRes;
            this.title = null;
            return this;
        }

        public Builder description(CharSequence description) {
            this.description = description;
            this.descriptionRes = 0;
            return this;
        }

        public Builder descriptionHtml(String descriptionHtml) {
            this.description = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)descriptionHtml, (int)0) : Html.fromHtml((String)descriptionHtml);
            this.descriptionRes = 0;
            return this;
        }

        public Builder description(@StringRes int descriptionRes) {
            this.descriptionRes = descriptionRes;
            this.description = null;
            return this;
        }

        public Builder image(@DrawableRes int imageRes) {
            this.imageRes = imageRes;
            return this;
        }

        public Builder layout(@LayoutRes int layoutRes) {
            this.layoutRes = layoutRes;
            return this;
        }

        public Builder scrollable(boolean scrollable) {
            this.layoutRes = scrollable ? R.layout.fragment_simple_slide_scrollable : R.layout.fragment_simple_slide;
            return this;
        }

        public Builder canGoForward(boolean canGoForward) {
            this.canGoForward = canGoForward;
            return this;
        }

        public Builder canGoBackward(boolean canGoBackward) {
            this.canGoBackward = canGoBackward;
            return this;
        }

        public Builder permissions(String[] permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder permission(String permission) {
            this.permissions = new String[]{permission};
            return this;
        }

        public Builder permissionsRequestCode(int permissionsRequestCode) {
            this.permissionsRequestCode = permissionsRequestCode;
            return this;
        }

        public Builder buttonCtaLabel(CharSequence buttonCtaLabel) {
            this.buttonCtaLabel = buttonCtaLabel;
            this.buttonCtaLabelRes = 0;
            return this;
        }

        public Builder buttonCtaLabelHtml(String buttonCtaLabelHtml) {
            this.buttonCtaLabel = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)buttonCtaLabelHtml, (int)0) : Html.fromHtml((String)buttonCtaLabelHtml);
            this.buttonCtaLabelRes = 0;
            return this;
        }

        public Builder buttonCtaLabel(@StringRes int buttonCtaLabelRes) {
            this.buttonCtaLabelRes = buttonCtaLabelRes;
            this.buttonCtaLabel = null;
            return this;
        }

        public Builder buttonCtaClickListener(View.OnClickListener buttonCtaClickListener) {
            this.buttonCtaClickListener = buttonCtaClickListener;
            return this;
        }

        public SimpleSlide build() {
            if (this.background == 0) {
                throw new IllegalArgumentException("You must set a background.");
            }
            return new SimpleSlide(this);
        }
    }
}

