/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.Interpolator;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.util.AnimUtils;
import java.util.Arrays;

public class InkPageIndicator
extends View
implements ViewPager.OnPageChangeListener,
View.OnAttachStateChangeListener {
    private static final int DEFAULT_DOT_SIZE = 8;
    private static final int DEFAULT_GAP = 12;
    private static final int DEFAULT_ANIM_DURATION = 400;
    private static final int DEFAULT_UNSELECTED_COLOUR = -2130706433;
    private static final int DEFAULT_SELECTED_COLOUR = -1;
    private static final float INVALID_FRACTION = -1.0f;
    private static final float MINIMAL_REVEAL = 1.0E-5f;
    private int dotDiameter;
    private int gap;
    private long animDuration;
    private int unselectedColour;
    private int selectedColour;
    private float dotRadius;
    private float halfDotRadius;
    private long animHalfDuration;
    private float dotTopY;
    private float dotCenterY;
    private float dotBottomY;
    private ViewPager viewPager;
    private int pageCount = 0;
    private int currentPage = 0;
    private int previousPage;
    private float selectedDotX;
    private boolean selectedDotInPosition;
    private float[] dotCenterX;
    private float[] joiningFractions;
    private float retreatingJoinX1;
    private float retreatingJoinX2;
    private float[] dotRevealFractions;
    private boolean isAttachedToWindow;
    private boolean pageChanging;
    private final Paint unselectedPaint;
    private final Paint selectedPaint;
    private final Path combinedUnselectedPath;
    private final Path unselectedDotPath;
    private final Path unselectedDotLeftPath;
    private final Path unselectedDotRightPath;
    private final RectF rectF;
    private PendingRetreatAnimator retreatAnimation;
    private PendingRevealAnimator[] revealAnimations;
    private final Interpolator interpolator;
    float endX1;
    float endY1;
    float endX2;
    float endY2;
    float controlX1;
    float controlY1;
    float controlX2;
    float controlY2;
    private boolean measured = false;

    public InkPageIndicator(Context context) {
        this(context, null, 0);
    }

    public InkPageIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public InkPageIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int density = (int)context.getResources().getDisplayMetrics().density;
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.InkPageIndicator, defStyle, 0);
        this.dotDiameter = a.getDimensionPixelSize(R.styleable.InkPageIndicator_dotDiameter, 8 * density);
        this.dotRadius = this.dotDiameter / 2;
        this.halfDotRadius = this.dotRadius / 2.0f;
        this.gap = a.getDimensionPixelSize(R.styleable.InkPageIndicator_dotGap, 12 * density);
        this.animDuration = a.getInteger(R.styleable.InkPageIndicator_animationDuration, 400);
        this.animHalfDuration = this.animDuration / 2L;
        this.unselectedColour = a.getColor(R.styleable.InkPageIndicator_pageIndicatorColor, -2130706433);
        this.selectedColour = a.getColor(R.styleable.InkPageIndicator_currentPageIndicatorColor, -1);
        a.recycle();
        this.unselectedPaint = new Paint(1);
        this.unselectedPaint.setColor(this.unselectedColour);
        this.selectedPaint = new Paint(1);
        this.selectedPaint.setColor(this.selectedColour);
        this.interpolator = AnimUtils.getFastOutSlowInInterpolator(context);
        this.combinedUnselectedPath = new Path();
        this.unselectedDotPath = new Path();
        this.unselectedDotLeftPath = new Path();
        this.unselectedDotRightPath = new Path();
        this.rectF = new RectF();
        this.addOnAttachStateChangeListener(this);
    }

    @ColorInt
    public int getPageIndicatorColor() {
        return this.unselectedPaint.getColor();
    }

    public void setPageIndicatorColor(@ColorInt int pageIndicatorColor) {
        this.unselectedPaint.setColor(pageIndicatorColor);
        this.invalidate();
    }

    @ColorInt
    public int getCurrentPageIndicatorColor() {
        return this.selectedPaint.getColor();
    }

    public void setCurrentPageIndicatorColor(@ColorInt int currentPageIndicatorColor) {
        this.selectedPaint.setColor(currentPageIndicatorColor);
        this.invalidate();
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.setPageCount(viewPager.getAdapter().getCount());
        viewPager.getAdapter().registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                InkPageIndicator.this.setPageCount(InkPageIndicator.this.viewPager.getAdapter().getCount());
                InkPageIndicator.this.invalidate();
            }
        });
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.isAttachedToWindow) {
            float fraction = positionOffset;
            int currentPosition = this.pageChanging ? this.previousPage : this.currentPage;
            int leftDotPosition = position;
            if (currentPosition != position && (fraction = 1.0f - positionOffset) == 1.0f) {
                leftDotPosition = Math.min(currentPosition, position);
            }
            this.setJoiningFraction(leftDotPosition, fraction);
        }
    }

    public void onPageSelected(int position) {
        if (this.isAttachedToWindow) {
            this.setSelectedPage(position);
        } else {
            this.setCurrentPageImmediate();
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void setPageCount(int pages) {
        this.pageCount = pages;
        this.calculateDotPositions(this.getWidth(), this.getHeight());
        this.resetState();
        this.requestLayout();
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.calculateDotPositions(w, h);
    }

    private void calculateDotPositions(int width, int height) {
        if (!this.measured) {
            return;
        }
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int right = width - this.getPaddingRight();
        int bottom = height - this.getPaddingBottom();
        float middle = (float)top + (float)bottom / 2.0f;
        float center = (float)left + (float)right / 2.0f;
        int requiredWidth = this.getRequiredWidth();
        float startLeft = center - (float)requiredWidth / 2.0f + this.dotRadius;
        this.dotCenterX = new float[Math.max(1, this.pageCount)];
        for (int i = 0; i < this.pageCount; ++i) {
            this.dotCenterX[i] = startLeft + (float)(i * (this.dotDiameter + this.gap));
        }
        this.dotTopY = middle - this.dotRadius;
        this.dotCenterY = middle;
        this.dotBottomY = middle + this.dotRadius;
        this.setCurrentPageImmediate();
    }

    private void setCurrentPageImmediate() {
        this.currentPage = this.viewPager != null ? this.viewPager.getCurrentItem() : 0;
        if (this.dotCenterX != null) {
            this.selectedDotX = this.dotCenterX[Math.max(0, Math.min(this.currentPage, this.dotCenterX.length - 1))];
        }
    }

    private void resetState() {
        this.joiningFractions = new float[Math.max(this.pageCount - 1, 0)];
        Arrays.fill(this.joiningFractions, 0.0f);
        this.dotRevealFractions = new float[this.pageCount];
        Arrays.fill(this.dotRevealFractions, 0.0f);
        this.retreatingJoinX1 = -1.0f;
        this.retreatingJoinX2 = -1.0f;
        this.selectedDotInPosition = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width;
        int height;
        int desiredHeight = this.getDesiredHeight();
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case 0x40000000: {
                height = View.MeasureSpec.getSize((int)heightMeasureSpec);
                break;
            }
            case -2147483648: {
                height = Math.min(desiredHeight, View.MeasureSpec.getSize((int)heightMeasureSpec));
                break;
            }
            default: {
                height = desiredHeight;
            }
        }
        int desiredWidth = this.getDesiredWidth();
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case 0x40000000: {
                width = View.MeasureSpec.getSize((int)widthMeasureSpec);
                break;
            }
            case -2147483648: {
                width = Math.min(desiredWidth, View.MeasureSpec.getSize((int)widthMeasureSpec));
                break;
            }
            default: {
                width = desiredWidth;
            }
        }
        this.setMeasuredDimension(width, height);
        if (!this.measured) {
            this.measured = true;
        }
    }

    private int getDesiredHeight() {
        return this.getPaddingTop() + this.dotDiameter + this.getPaddingBottom();
    }

    private int getRequiredWidth() {
        return this.pageCount * this.dotDiameter + (this.pageCount - 1) * this.gap;
    }

    private int getDesiredWidth() {
        return this.getPaddingLeft() + this.getRequiredWidth() + this.getPaddingRight();
    }

    public void onViewAttachedToWindow(View view) {
        this.isAttachedToWindow = true;
    }

    public void onViewDetachedFromWindow(View view) {
        this.isAttachedToWindow = false;
    }

    protected void onDraw(Canvas canvas) {
        if (this.viewPager == null || this.pageCount == 0) {
            return;
        }
        this.drawUnselected(canvas);
        this.drawSelected(canvas);
    }

    private void drawUnselected(Canvas canvas) {
        this.combinedUnselectedPath.rewind();
        for (int page = 0; page < this.pageCount; ++page) {
            int nextXIndex = page == this.pageCount - 1 ? page : page + 1;
            Path unselectedPath = this.getUnselectedPath(page, this.dotCenterX[page], this.dotCenterX[nextXIndex], page == this.pageCount - 1 ? -1.0f : this.joiningFractions[page], this.dotRevealFractions[page]);
            if (Build.VERSION.SDK_INT >= 19) {
                this.combinedUnselectedPath.op(unselectedPath, Path.Op.UNION);
                continue;
            }
            this.combinedUnselectedPath.addPath(unselectedPath);
        }
        if (this.retreatingJoinX1 != -1.0f) {
            Path retreatingJoinPath = this.getRetreatingJoinPath();
            if (Build.VERSION.SDK_INT >= 19) {
                this.combinedUnselectedPath.op(retreatingJoinPath, Path.Op.UNION);
            } else {
                this.combinedUnselectedPath.addPath(retreatingJoinPath);
            }
        }
        canvas.drawPath(this.combinedUnselectedPath, this.unselectedPaint);
    }

    private Path getUnselectedPath(int page, float centerX, float nextCenterX, float joiningFraction, float dotRevealFraction) {
        this.unselectedDotPath.rewind();
        if (!(joiningFraction != 0.0f && joiningFraction != -1.0f || dotRevealFraction != 0.0f || page == this.currentPage && this.selectedDotInPosition)) {
            this.unselectedDotPath.addCircle(this.dotCenterX[page], this.dotCenterY, this.dotRadius, Path.Direction.CW);
        }
        if (joiningFraction > 0.0f && joiningFraction <= 0.5f && this.retreatingJoinX1 == -1.0f) {
            this.unselectedDotLeftPath.rewind();
            this.unselectedDotLeftPath.moveTo(centerX, this.dotBottomY);
            this.rectF.set(centerX - this.dotRadius, this.dotTopY, centerX + this.dotRadius, this.dotBottomY);
            this.unselectedDotLeftPath.arcTo(this.rectF, 90.0f, 180.0f, true);
            this.endX1 = centerX + this.dotRadius + joiningFraction * (float)this.gap;
            this.endY1 = this.dotCenterY;
            this.controlX1 = centerX + this.halfDotRadius;
            this.controlY1 = this.dotTopY;
            this.controlX2 = this.endX1;
            this.controlY2 = this.endY1 - this.halfDotRadius;
            this.unselectedDotLeftPath.cubicTo(this.controlX1, this.controlY1, this.controlX2, this.controlY2, this.endX1, this.endY1);
            this.endX2 = centerX;
            this.endY2 = this.dotBottomY;
            this.controlX1 = this.endX1;
            this.controlY1 = this.endY1 + this.halfDotRadius;
            this.controlX2 = centerX + this.halfDotRadius;
            this.controlY2 = this.dotBottomY;
            this.unselectedDotLeftPath.cubicTo(this.controlX1, this.controlY1, this.controlX2, this.controlY2, this.endX2, this.endY2);
            if (Build.VERSION.SDK_INT >= 19) {
                this.unselectedDotPath.op(this.unselectedDotLeftPath, Path.Op.UNION);
            } else {
                this.unselectedDotPath.addPath(this.unselectedDotLeftPath);
            }
            this.unselectedDotRightPath.rewind();
            this.unselectedDotRightPath.moveTo(nextCenterX, this.dotBottomY);
            this.rectF.set(nextCenterX - this.dotRadius, this.dotTopY, nextCenterX + this.dotRadius, this.dotBottomY);
            this.unselectedDotRightPath.arcTo(this.rectF, 90.0f, -180.0f, true);
            this.endX1 = nextCenterX - this.dotRadius - joiningFraction * (float)this.gap;
            this.endY1 = this.dotCenterY;
            this.controlX1 = nextCenterX - this.halfDotRadius;
            this.controlY1 = this.dotTopY;
            this.controlX2 = this.endX1;
            this.controlY2 = this.endY1 - this.halfDotRadius;
            this.unselectedDotRightPath.cubicTo(this.controlX1, this.controlY1, this.controlX2, this.controlY2, this.endX1, this.endY1);
            this.endX2 = nextCenterX;
            this.endY2 = this.dotBottomY;
            this.controlX1 = this.endX1;
            this.controlY1 = this.endY1 + this.halfDotRadius;
            this.controlX2 = this.endX2 - this.halfDotRadius;
            this.controlY2 = this.dotBottomY;
            this.unselectedDotRightPath.cubicTo(this.controlX1, this.controlY1, this.controlX2, this.controlY2, this.endX2, this.endY2);
            if (Build.VERSION.SDK_INT >= 19) {
                this.unselectedDotPath.op(this.unselectedDotRightPath, Path.Op.UNION);
            } else {
                this.unselectedDotPath.addPath(this.unselectedDotRightPath);
            }
        }
        if (joiningFraction > 0.5f && joiningFraction < 1.0f && this.retreatingJoinX1 == -1.0f) {
            float adjustedFraction = (joiningFraction - 0.2f) * 1.25f;
            this.unselectedDotPath.moveTo(centerX, this.dotBottomY);
            this.rectF.set(centerX - this.dotRadius, this.dotTopY, centerX + this.dotRadius, this.dotBottomY);
            this.unselectedDotPath.arcTo(this.rectF, 90.0f, 180.0f, true);
            this.endX1 = centerX + this.dotRadius + (float)(this.gap / 2);
            this.endY1 = this.dotCenterY - adjustedFraction * this.dotRadius;
            this.controlX1 = this.endX1 - adjustedFraction * this.dotRadius;
            this.controlY1 = this.dotTopY;
            this.controlX2 = this.endX1 - (1.0f - adjustedFraction) * this.dotRadius;
            this.controlY2 = this.endY1;
            this.unselectedDotPath.cubicTo(this.controlX1, this.controlY1, this.controlX2, this.controlY2, this.endX1, this.endY1);
            this.endX2 = nextCenterX;
            this.endY2 = this.dotTopY;
            this.controlX1 = this.endX1 + (1.0f - adjustedFraction) * this.dotRadius;
            this.controlY1 = this.endY1;
            this.controlX2 = this.endX1 + adjustedFraction * this.dotRadius;
            this.controlY2 = this.dotTopY;
            this.unselectedDotPath.cubicTo(this.controlX1, this.controlY1, this.controlX2, this.controlY2, this.endX2, this.endY2);
            this.rectF.set(nextCenterX - this.dotRadius, this.dotTopY, nextCenterX + this.dotRadius, this.dotBottomY);
            this.unselectedDotPath.arcTo(this.rectF, 270.0f, 180.0f, true);
            this.endY1 = this.dotCenterY + adjustedFraction * this.dotRadius;
            this.controlX1 = this.endX1 + adjustedFraction * this.dotRadius;
            this.controlY1 = this.dotBottomY;
            this.controlX2 = this.endX1 + (1.0f - adjustedFraction) * this.dotRadius;
            this.controlY2 = this.endY1;
            this.unselectedDotPath.cubicTo(this.controlX1, this.controlY1, this.controlX2, this.controlY2, this.endX1, this.endY1);
            this.endX2 = centerX;
            this.endY2 = this.dotBottomY;
            this.controlX1 = this.endX1 - (1.0f - adjustedFraction) * this.dotRadius;
            this.controlY1 = this.endY1;
            this.controlX2 = this.endX1 - adjustedFraction * this.dotRadius;
            this.controlY2 = this.endY2;
            this.unselectedDotPath.cubicTo(this.controlX1, this.controlY1, this.controlX2, this.controlY2, this.endX2, this.endY2);
        }
        if (joiningFraction == 1.0f && this.retreatingJoinX1 == -1.0f) {
            this.rectF.set(centerX - this.dotRadius, this.dotTopY, nextCenterX + this.dotRadius, this.dotBottomY);
            this.unselectedDotPath.addRoundRect(this.rectF, this.dotRadius, this.dotRadius, Path.Direction.CW);
        }
        if (dotRevealFraction > 1.0E-5f) {
            this.unselectedDotPath.addCircle(centerX, this.dotCenterY, dotRevealFraction * this.dotRadius, Path.Direction.CW);
        }
        return this.unselectedDotPath;
    }

    private Path getRetreatingJoinPath() {
        this.unselectedDotPath.rewind();
        this.rectF.set(this.retreatingJoinX1, this.dotTopY, this.retreatingJoinX2, this.dotBottomY);
        this.unselectedDotPath.addRoundRect(this.rectF, this.dotRadius, this.dotRadius, Path.Direction.CW);
        return this.unselectedDotPath;
    }

    private void drawSelected(Canvas canvas) {
        canvas.drawCircle(this.selectedDotX, this.dotCenterY, this.dotRadius, this.selectedPaint);
    }

    private void setSelectedPage(int now) {
        if ((now = Math.min(now, this.pageCount - 1)) == this.currentPage) {
            return;
        }
        this.pageChanging = true;
        this.previousPage = this.currentPage;
        Log.i((String)"IPI", (String)("setSelectedPage: currentPage(before): " + this.currentPage));
        this.currentPage = now;
        Log.i((String)"IPI", (String)("setSelectedPage: currentPage(after): " + this.currentPage));
        int steps = Math.abs(now - this.previousPage);
        if (steps > 1) {
            if (now > this.previousPage) {
                for (int i = 0; i < steps; ++i) {
                    this.setJoiningFraction(this.previousPage + i, 1.0f);
                }
            } else {
                for (int i = -1; i > -steps; --i) {
                    this.setJoiningFraction(this.previousPage + i, 1.0f);
                }
            }
        }
        this.createMoveSelectedAnimator(this.dotCenterX[now], this.previousPage, now, steps).start();
    }

    private ValueAnimator createMoveSelectedAnimator(float moveTo, int was, int now, int steps) {
        ValueAnimator moveSelected = ValueAnimator.ofFloat((float[])new float[]{this.selectedDotX, moveTo});
        this.retreatAnimation = new PendingRetreatAnimator(was, now, steps, now > was ? new RightwardStartPredicate(moveTo - (moveTo - this.selectedDotX) * 0.25f) : new LeftwardStartPredicate(moveTo + (this.selectedDotX - moveTo) * 0.25f));
        this.retreatAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                InkPageIndicator.this.resetState();
                InkPageIndicator.this.pageChanging = false;
            }
        });
        moveSelected.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                InkPageIndicator.this.selectedDotX = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                InkPageIndicator.this.retreatAnimation.startIfNecessary(InkPageIndicator.this.selectedDotX);
                if (Build.VERSION.SDK_INT >= 16) {
                    InkPageIndicator.this.postInvalidateOnAnimation();
                } else {
                    InkPageIndicator.this.postInvalidate();
                }
            }
        });
        moveSelected.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                InkPageIndicator.this.selectedDotInPosition = false;
            }

            public void onAnimationEnd(Animator animation) {
                InkPageIndicator.this.selectedDotInPosition = true;
            }
        });
        moveSelected.setStartDelay(this.selectedDotInPosition ? this.animDuration / 4L : 0L);
        moveSelected.setDuration(this.animDuration * 3L / 4L);
        moveSelected.setInterpolator((TimeInterpolator)this.interpolator);
        return moveSelected;
    }

    private void setJoiningFraction(int leftDot, float fraction) {
        if (leftDot < this.joiningFractions.length) {
            this.joiningFractions[leftDot] = fraction;
            if (Build.VERSION.SDK_INT >= 16) {
                this.postInvalidateOnAnimation();
            } else {
                this.postInvalidate();
            }
        }
    }

    private void clearJoiningFractions() {
        Arrays.fill(this.joiningFractions, 0.0f);
        if (Build.VERSION.SDK_INT >= 16) {
            this.postInvalidateOnAnimation();
        } else {
            this.postInvalidate();
        }
    }

    private void setDotRevealFraction(int dot, float fraction) {
        this.dotRevealFractions[dot] = fraction;
        if (Build.VERSION.SDK_INT >= 16) {
            this.postInvalidateOnAnimation();
        } else {
            this.postInvalidate();
        }
    }

    static /* synthetic */ PendingRevealAnimator[] access$1102(InkPageIndicator x0, PendingRevealAnimator[] x1) {
        x0.revealAnimations = x1;
        return x1;
    }

    public class LeftwardStartPredicate
    extends StartPredicate {
        public LeftwardStartPredicate(float thresholdValue) {
            super(thresholdValue);
        }

        @Override
        boolean shouldStart(float currentValue) {
            return currentValue < this.thresholdValue;
        }
    }

    public class RightwardStartPredicate
    extends StartPredicate {
        public RightwardStartPredicate(float thresholdValue) {
            super(thresholdValue);
        }

        @Override
        boolean shouldStart(float currentValue) {
            return currentValue > this.thresholdValue;
        }
    }

    public abstract class StartPredicate {
        protected float thresholdValue;

        public StartPredicate(float thresholdValue) {
            this.thresholdValue = thresholdValue;
        }

        abstract boolean shouldStart(float var1);
    }

    public class PendingRevealAnimator
    extends PendingStartAnimator {
        private int dot;

        public PendingRevealAnimator(int dot, StartPredicate predicate) {
            super(predicate);
            this.setFloatValues(new float[]{1.0E-5f, 1.0f});
            this.dot = dot;
            this.setDuration(InkPageIndicator.this.animHalfDuration);
            this.setInterpolator((TimeInterpolator)InkPageIndicator.this.interpolator);
            this.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    InkPageIndicator.this.setDotRevealFraction(PendingRevealAnimator.this.dot, ((Float)valueAnimator.getAnimatedValue()).floatValue());
                }
            });
            this.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    InkPageIndicator.this.setDotRevealFraction(PendingRevealAnimator.this.dot, 0.0f);
                    if (Build.VERSION.SDK_INT >= 16) {
                        InkPageIndicator.this.postInvalidateOnAnimation();
                    } else {
                        InkPageIndicator.this.postInvalidate();
                    }
                }
            });
        }
    }

    public class PendingRetreatAnimator
    extends PendingStartAnimator {
        public PendingRetreatAnimator(int was, int now, int steps, StartPredicate predicate) {
            super(predicate);
            this.setDuration(InkPageIndicator.this.animHalfDuration);
            this.setInterpolator((TimeInterpolator)InkPageIndicator.this.interpolator);
            final float initialX1 = now > was ? Math.min(InkPageIndicator.this.dotCenterX[was], InkPageIndicator.this.selectedDotX) - InkPageIndicator.this.dotRadius : InkPageIndicator.this.dotCenterX[now] - InkPageIndicator.this.dotRadius;
            float finalX1 = now > was ? InkPageIndicator.this.dotCenterX[now] - InkPageIndicator.this.dotRadius : InkPageIndicator.this.dotCenterX[now] - InkPageIndicator.this.dotRadius;
            final float initialX2 = now > was ? InkPageIndicator.this.dotCenterX[now] + InkPageIndicator.this.dotRadius : Math.max(InkPageIndicator.this.dotCenterX[was], InkPageIndicator.this.selectedDotX) + InkPageIndicator.this.dotRadius;
            float finalX2 = now > was ? InkPageIndicator.this.dotCenterX[now] + InkPageIndicator.this.dotRadius : InkPageIndicator.this.dotCenterX[now] + InkPageIndicator.this.dotRadius;
            InkPageIndicator.access$1102(InkPageIndicator.this, new PendingRevealAnimator[steps]);
            final int[] dotsToHide = new int[steps];
            if (initialX1 != finalX1) {
                this.setFloatValues(new float[]{initialX1, finalX1});
                for (int i = 0; i < steps; ++i) {
                    ((InkPageIndicator)InkPageIndicator.this).revealAnimations[i] = new PendingRevealAnimator(was + i, new RightwardStartPredicate(InkPageIndicator.this.dotCenterX[was + i]));
                    dotsToHide[i] = was + i;
                }
                this.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        InkPageIndicator.this.retreatingJoinX1 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                        if (Build.VERSION.SDK_INT >= 16) {
                            InkPageIndicator.this.postInvalidateOnAnimation();
                        } else {
                            InkPageIndicator.this.postInvalidate();
                        }
                        for (PendingRevealAnimator pendingReveal : InkPageIndicator.this.revealAnimations) {
                            pendingReveal.startIfNecessary(InkPageIndicator.this.retreatingJoinX1);
                        }
                    }
                });
            } else {
                this.setFloatValues(new float[]{initialX2, finalX2});
                for (int i = 0; i < steps; ++i) {
                    ((InkPageIndicator)InkPageIndicator.this).revealAnimations[i] = new PendingRevealAnimator(was - i, new LeftwardStartPredicate(InkPageIndicator.this.dotCenterX[was - i]));
                    dotsToHide[i] = was - i;
                }
                this.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        InkPageIndicator.this.retreatingJoinX2 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                        if (Build.VERSION.SDK_INT >= 16) {
                            InkPageIndicator.this.postInvalidateOnAnimation();
                        } else {
                            InkPageIndicator.this.postInvalidate();
                        }
                        for (PendingRevealAnimator pendingReveal : InkPageIndicator.this.revealAnimations) {
                            pendingReveal.startIfNecessary(InkPageIndicator.this.retreatingJoinX2);
                        }
                    }
                });
            }
            this.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    InkPageIndicator.this.clearJoiningFractions();
                    for (int dot : dotsToHide) {
                        InkPageIndicator.this.setDotRevealFraction(dot, 1.0E-5f);
                    }
                    InkPageIndicator.this.retreatingJoinX1 = initialX1;
                    InkPageIndicator.this.retreatingJoinX2 = initialX2;
                    if (Build.VERSION.SDK_INT >= 16) {
                        InkPageIndicator.this.postInvalidateOnAnimation();
                    } else {
                        InkPageIndicator.this.postInvalidate();
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    InkPageIndicator.this.retreatingJoinX1 = -1.0f;
                    InkPageIndicator.this.retreatingJoinX2 = -1.0f;
                    if (Build.VERSION.SDK_INT >= 16) {
                        InkPageIndicator.this.postInvalidateOnAnimation();
                    } else {
                        InkPageIndicator.this.postInvalidate();
                    }
                }
            });
        }
    }

    public abstract class PendingStartAnimator
    extends ValueAnimator {
        protected boolean hasStarted;
        protected StartPredicate predicate;

        public PendingStartAnimator(StartPredicate predicate) {
            this.predicate = predicate;
            this.hasStarted = false;
        }

        public void startIfNecessary(float currentValue) {
            if (!this.hasStarted && this.predicate.shouldStart(currentValue)) {
                this.start();
                this.hasStarted = true;
            }
        }
    }
}

