/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.app;

import android.animation.ArgbEvaluator;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import com.heinrichreimersoftware.materialintro.slide.SlideAdapter;
import com.heinrichreimersoftware.materialintro.util.CheatSheet;
import com.heinrichreimersoftware.materialintro.view.FadeableViewPager;
import com.heinrichreimersoftware.materialintro.view.InkPageIndicator;
import java.util.Collection;
import java.util.List;

@SuppressLint(value={"Registered"})
public class IntroActivity
extends AppCompatActivity {
    private final ArgbEvaluator evaluator = new ArgbEvaluator();
    private FrameLayout frame;
    private ViewPager pager;
    private InkPageIndicator pagerIndicator;
    private View buttonNext;
    private View buttonSkip;
    private SlideAdapter adapter;
    private IntroPageChangeListener listener = new IntroPageChangeListener();
    private boolean fullscreen = false;
    private boolean skipEnabled = true;
    private boolean finishEnabled = true;
    private int position = 0;
    private float positionOffset = 0.0f;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.fullscreen && Build.VERSION.SDK_INT >= 19) {
            this.setSystemUiFlags(1280, true);
            this.setFullscreenFlags(this.fullscreen);
        }
        this.setContentView(R.layout.activity_intro);
        this.findViews();
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.updateTaskDescription();
        this.updateBackground();
        this.updateTaskDescription();
        this.updateButtonNextDrawable();
        this.updateButtonSkipDrawable();
        this.frame.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                IntroActivity.this.updateViewPositions();
                v.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.setFullscreenFlags(this.fullscreen);
    }

    private void setSystemUiFlags(int flags, boolean value) {
        int systemUiVisibility = this.getWindow().getDecorView().getSystemUiVisibility();
        systemUiVisibility = value ? (systemUiVisibility |= flags) : (systemUiVisibility &= ~flags);
        this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility);
    }

    private void setFullscreenFlags(boolean fullscreen) {
        if (Build.VERSION.SDK_INT >= 19) {
            int fullscreenFlags = 4100;
            this.setSystemUiFlags(fullscreenFlags, fullscreen);
        }
    }

    private void findViews() {
        this.frame = (FrameLayout)this.findViewById(R.id.mi_frame);
        this.pager = (ViewPager)this.findViewById(R.id.mi_pager);
        this.pagerIndicator = (InkPageIndicator)this.findViewById(R.id.mi_pager_indicator);
        this.buttonNext = this.findViewById(R.id.mi_button_next);
        this.buttonSkip = this.findViewById(R.id.mi_button_skip);
        this.adapter = new SlideAdapter(this.getSupportFragmentManager());
        this.pager.setAdapter((PagerAdapter)this.adapter);
        this.pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.listener);
        this.pagerIndicator.setViewPager(this.pager);
        this.buttonNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntroActivity.this.nextSlide();
            }
        });
        this.buttonSkip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntroActivity.this.skipIfEnabled();
            }
        });
        CheatSheet.setup(this.buttonNext);
        CheatSheet.setup(this.buttonSkip);
    }

    private void nextSlide() {
        int currentItem = this.pager.getCurrentItem();
        this.pager.setCurrentItem(++currentItem, true);
    }

    private void previousSlide() {
        int currentItem = this.pager.getCurrentItem();
        this.pager.setCurrentItem(--currentItem, true);
    }

    private void skipIfEnabled() {
        if (this.skipEnabled) {
            int count = this.getCount();
            this.pager.setCurrentItem(count);
        } else {
            this.previousSlide();
        }
    }

    private void finishIfNeeded() {
        if (this.positionOffset == 0.0f && this.position == this.adapter.getCount()) {
            this.finish();
            this.overridePendingTransition(0, 0);
        }
    }

    private void updateFullscreen() {
        if ((float)this.position + this.positionOffset > (float)(this.adapter.getCount() - 1)) {
            this.setFullscreenFlags(false);
        } else {
            this.setFullscreenFlags(this.fullscreen);
        }
    }

    private void updateTaskDescription() {
        if (Build.VERSION.SDK_INT >= 21) {
            int colorPrimary;
            Bitmap icon;
            String title = this.getTitle().toString();
            Drawable iconDrawable = this.getApplicationInfo().loadIcon(this.getPackageManager());
            Bitmap bitmap = icon = iconDrawable instanceof BitmapDrawable ? ((BitmapDrawable)iconDrawable).getBitmap() : null;
            if (this.position < this.getCount()) {
                try {
                    colorPrimary = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(this.position));
                }
                catch (Resources.NotFoundException e) {
                    colorPrimary = ContextCompat.getColor((Context)this, (int)this.getBackground(this.position));
                }
            } else {
                TypedValue typedValue = new TypedValue();
                TypedArray a = this.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorPrimary});
                colorPrimary = a.getColor(0, 0);
                a.recycle();
            }
            colorPrimary = ColorUtils.setAlphaComponent((int)colorPrimary, (int)255);
            this.setTaskDescription(new ActivityManager.TaskDescription(title, icon, colorPrimary));
        }
    }

    private void updateBackground() {
        int backgroundNext;
        int background;
        if (this.position == this.getCount()) {
            background = 0;
            backgroundNext = 0;
        } else {
            background = ContextCompat.getColor((Context)this, (int)this.getBackground(this.position));
            backgroundNext = ContextCompat.getColor((Context)this, (int)this.getBackground(Math.min(this.position + 1, this.getCount() - 1)));
            background = ColorUtils.setAlphaComponent((int)background, (int)255);
            backgroundNext = ColorUtils.setAlphaComponent((int)backgroundNext, (int)255);
        }
        if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 1)) {
            backgroundNext = ColorUtils.setAlphaComponent((int)background, (int)0);
        }
        this.frame.setBackgroundColor(((Integer)this.evaluator.evaluate(this.positionOffset, (Object)background, (Object)backgroundNext)).intValue());
        if (Build.VERSION.SDK_INT >= 21) {
            int backgroundDarkNext;
            int backgroundDark;
            if (this.position == this.getCount()) {
                backgroundDark = 0;
                backgroundDarkNext = 0;
            } else {
                try {
                    backgroundDark = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(this.position));
                }
                catch (Resources.NotFoundException e) {
                    backgroundDark = ContextCompat.getColor((Context)this, (int)R.color.mi_status_bar_background);
                }
                try {
                    backgroundDarkNext = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(Math.min(this.position + 1, this.getCount() - 1)));
                }
                catch (Resources.NotFoundException e) {
                    backgroundDarkNext = ContextCompat.getColor((Context)this, (int)R.color.mi_status_bar_background);
                }
            }
            if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 1)) {
                backgroundDarkNext = 0;
            }
            backgroundDark = (Integer)this.evaluator.evaluate(this.positionOffset, (Object)backgroundDark, (Object)backgroundDarkNext);
            this.getWindow().setStatusBarColor(backgroundDark);
            if (this.position == this.adapter.getCount()) {
                this.getWindow().setNavigationBarColor(0);
            } else if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 1)) {
                TypedValue typedValue = new TypedValue();
                TypedArray a = this.obtainStyledAttributes(typedValue.data, new int[]{16843858});
                int defaultNavigationBarColor = a.getColor(0, -16777216);
                a.recycle();
                int navigationBarColor = (Integer)this.evaluator.evaluate(this.positionOffset, (Object)defaultNavigationBarColor, (Object)0);
                this.getWindow().setNavigationBarColor(navigationBarColor);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                int systemUiVisibility = this.getWindow().getDecorView().getSystemUiVisibility();
                int flagLightStatusBar = 8192;
                systemUiVisibility = ColorUtils.calculateLuminance((int)backgroundDark) > 0.4 ? (systemUiVisibility |= flagLightStatusBar) : (systemUiVisibility &= ~flagLightStatusBar);
                this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility);
            }
        }
    }

    private void updateViewPositions() {
        if ((float)this.position + this.positionOffset < 1.0f) {
            float offset = (float)this.position + this.positionOffset;
            if (this.skipEnabled) {
                this.buttonSkip.setTranslationY(0.0f);
            } else {
                this.buttonSkip.setTranslationY((1.0f - offset) * 2.0f * (float)this.buttonNext.getHeight());
            }
            this.updateButtonNextDrawable();
        } else if ((float)this.position + this.positionOffset >= 1.0f && (float)this.position + this.positionOffset < (float)(this.adapter.getCount() - 2)) {
            this.buttonSkip.setTranslationY(0.0f);
            this.buttonSkip.setTranslationX(0.0f);
            this.buttonNext.setTranslationY(0.0f);
            this.updateButtonNextDrawable();
        } else if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 2) && (float)this.position + this.positionOffset < (float)(this.adapter.getCount() - 1)) {
            float offset = (float)this.position + this.positionOffset - (float)this.adapter.getCount() + 2.0f;
            if (this.skipEnabled) {
                boolean rtl = Build.VERSION.SDK_INT >= 17 && this.getResources().getConfiguration().getLayoutDirection() == 1;
                this.buttonSkip.setTranslationX(offset * (float)(rtl ? 1 : -1) * (float)this.pager.getWidth());
            } else {
                this.buttonSkip.setTranslationX(0.0f);
            }
            if (this.finishEnabled) {
                this.buttonNext.setTranslationY(0.0f);
            } else {
                this.buttonNext.setTranslationY(offset * 2.0f * (float)this.buttonNext.getHeight());
            }
            this.updateButtonNextDrawable();
        } else if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 1)) {
            float offset = (float)this.position + this.positionOffset - (float)this.adapter.getCount() + 1.0f;
            if (this.skipEnabled) {
                boolean rtl = Build.VERSION.SDK_INT >= 17 && this.getResources().getConfiguration().getLayoutDirection() == 1;
                this.buttonSkip.setTranslationX((float)((rtl ? 1 : -1) * this.pager.getWidth()));
            } else {
                this.buttonSkip.setTranslationY(offset * 2.0f * (float)this.buttonNext.getHeight());
            }
            if (this.finishEnabled) {
                this.buttonNext.setTranslationY(offset * 2.0f * (float)this.buttonNext.getHeight());
            } else {
                this.buttonNext.setTranslationY((float)(-2 * this.buttonNext.getHeight()));
            }
            this.pagerIndicator.setTranslationY(offset * 2.0f * (float)this.buttonNext.getWidth());
            this.updateButtonNextDrawable();
        }
    }

    private void updateButtonNextDrawable() {
        if (this.buttonNext != null && this.buttonNext instanceof ImageButton) {
            ImageButton button = (ImageButton)this.buttonNext;
            float offset = 0.0f;
            if (this.finishEnabled && (float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 2)) {
                offset = Math.min((float)this.position + this.positionOffset - (float)this.adapter.getCount() + 2.0f, 1.0f);
            }
            if (offset <= 0.0f) {
                button.setImageResource(R.drawable.ic_next);
                button.getDrawable().setAlpha(255);
            } else {
                button.setImageResource(R.drawable.ic_next_finish);
                if (button.getDrawable() != null && button.getDrawable() instanceof LayerDrawable) {
                    LayerDrawable drawable2 = (LayerDrawable)button.getDrawable();
                    drawable2.getDrawable(0).setAlpha((int)(255.0f * (1.0f - offset)));
                    drawable2.getDrawable(1).setAlpha((int)(255.0f * offset));
                } else {
                    button.setImageResource(offset > 0.0f ? R.drawable.ic_finish : R.drawable.ic_next);
                }
            }
        }
    }

    private void updateButtonSkipDrawable() {
        if (this.buttonSkip != null && this.buttonSkip instanceof ImageButton) {
            ImageButton button = (ImageButton)this.buttonSkip;
            if (this.skipEnabled) {
                button.setImageResource(R.drawable.ic_skip);
            } else {
                button.setImageResource(R.drawable.ic_previous);
            }
        }
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public boolean isSkipEnabled() {
        return this.skipEnabled;
    }

    public void setSkipEnabled(boolean skipEnabled) {
        this.skipEnabled = skipEnabled;
        this.updateButtonSkipDrawable();
        this.updateViewPositions();
    }

    public boolean isFinishEnabled() {
        return this.finishEnabled;
    }

    public void setFinishEnabled(boolean finishEnabled) {
        this.finishEnabled = finishEnabled;
        this.updateButtonNextDrawable();
        this.updateViewPositions();
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.pager.setOnPageChangeListener(listener);
        this.pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.listener);
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.pager.addOnPageChangeListener(listener);
    }

    public void removeOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        if (listener != this.listener) {
            this.pager.removeOnPageChangeListener(listener);
        }
    }

    protected void addSlide(int location, Slide object) {
        this.adapter.addSlide(location, object);
    }

    protected boolean addSlide(Slide object) {
        return this.adapter.addSlide(object);
    }

    protected boolean addSlides(int location, @NonNull Collection<? extends Slide> collection) {
        return this.adapter.addSlides(location, collection);
    }

    protected boolean addSlides(@NonNull Collection<? extends Slide> collection) {
        return this.adapter.addSlides(collection);
    }

    protected void clearSlides() {
        this.adapter.clearSlides();
    }

    protected boolean containsSlide(Object object) {
        return this.adapter.containsSlide(object);
    }

    protected boolean containsSlides(@NonNull Collection<?> collection) {
        return this.adapter.containsSlides(collection);
    }

    protected Slide getSlide(int location) {
        return this.adapter.getSlide(location);
    }

    protected Fragment getItem(int position) {
        return this.adapter.getItem(position);
    }

    @ColorRes
    protected int getBackground(int position) {
        return this.adapter.getBackground(position);
    }

    @ColorRes
    protected int getBackgroundDark(int position) {
        return this.adapter.getBackgroundDark(position);
    }

    protected List<Slide> getSlides() {
        return this.adapter.getSlides();
    }

    protected int indexOfSlide(Object object) {
        return this.adapter.indexOfSlide(object);
    }

    protected boolean isEmpty() {
        return this.adapter.isEmpty();
    }

    protected int getCount() {
        return this.adapter.getCount();
    }

    protected int lastIndexOfSlide(Object object) {
        return this.adapter.lastIndexOfSlide(object);
    }

    protected Slide removeSlide(int location) {
        return this.adapter.removeSlide(location);
    }

    protected boolean removeSlide(Object object) {
        return this.adapter.removeSlide(object);
    }

    protected boolean removeSlides(@NonNull Collection<?> collection) {
        return this.adapter.removeSlides(collection);
    }

    protected boolean retainSlides(@NonNull Collection<?> collection) {
        return this.adapter.retainSlides(collection);
    }

    protected Slide setSlide(int location, Slide object) {
        return this.adapter.setSlide(location, object);
    }

    protected List<Slide> setSlides(List<? extends Slide> list) {
        return this.adapter.setSlides(list);
    }

    private class IntroPageChangeListener
    extends FadeableViewPager.SimpleOnOverscrollPageChangeListener {
        private IntroPageChangeListener() {
        }

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            IntroActivity.this.position = position;
            IntroActivity.this.positionOffset = positionOffset;
            IntroActivity.this.updateBackground();
            IntroActivity.this.updateViewPositions();
            IntroActivity.this.updateFullscreen();
            IntroActivity.this.finishIfNeeded();
        }

        @Override
        public void onPageSelected(int position) {
            IntroActivity.this.position = position;
            IntroActivity.this.updateTaskDescription();
        }
    }
}

