/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.app;

import android.animation.ArgbEvaluator;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import com.heinrichreimersoftware.materialintro.slide.SlideAdapter;
import com.heinrichreimersoftware.materialintro.util.CheatSheet;
import com.heinrichreimersoftware.materialintro.view.FadeableViewPager;
import com.heinrichreimersoftware.materialintro.view.InkPageIndicator;
import java.util.Collection;
import java.util.List;

@SuppressLint(value={"Registered"})
public class IntroActivity
extends AppCompatActivity {
    private FrameLayout frame;
    private ViewPager pager;
    private InkPageIndicator pagerIndicator;
    private View buttonNext;
    private View buttonSkip;
    private SlideAdapter adapter;
    private boolean fullscreen = true;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.fullscreen && Build.VERSION.SDK_INT >= 19) {
            this.setSystemUiFlags(1280, true);
            this.setFullscreenFlags(this.fullscreen);
        }
        this.setContentView(R.layout.activity_intro);
        this.findViews();
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.updateTaskDescription();
    }

    protected void onResume() {
        super.onResume();
        this.setFullscreenFlags(this.fullscreen);
    }

    private void setSystemUiFlags(int flags, boolean value) {
        int systemUiVisibility = this.getWindow().getDecorView().getSystemUiVisibility();
        systemUiVisibility = value ? (systemUiVisibility |= flags) : (systemUiVisibility &= ~flags);
        this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility);
    }

    private void setFullscreenFlags(boolean fullscreen) {
        if (Build.VERSION.SDK_INT >= 19) {
            int fullscreenFlags = 4100;
            this.setSystemUiFlags(fullscreenFlags, fullscreen);
        }
    }

    protected void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    private void findViews() {
        this.frame = (FrameLayout)this.findViewById(R.id.mi_frame);
        this.pager = (ViewPager)this.findViewById(R.id.mi_pager);
        this.pagerIndicator = (InkPageIndicator)this.findViewById(R.id.mi_pager_indicator);
        this.buttonNext = this.findViewById(R.id.mi_button_next);
        this.buttonSkip = this.findViewById(R.id.mi_button_skip);
        this.adapter = new SlideAdapter(this.getSupportFragmentManager());
        this.pager.setAdapter((PagerAdapter)this.adapter);
        this.pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ButtonListener());
        this.pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new BackgroundListener());
        this.pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new TaskDescriptionListener());
        this.pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new FinishListener());
        this.pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new FullscreenListener());
        this.pagerIndicator.setViewPager(this.pager);
        this.buttonNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntroActivity.this.nextSlide();
            }
        });
        this.buttonSkip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntroActivity.this.finishIntro();
            }
        });
        CheatSheet.setup(this.buttonNext);
        CheatSheet.setup(this.buttonSkip);
    }

    private void nextSlide() {
        int currentItem = this.pager.getCurrentItem();
        this.pager.setCurrentItem(++currentItem, true);
    }

    private void finishIntro() {
        int count = this.getCount();
        this.pager.setCurrentItem(count);
    }

    private void updateTaskDescription(int position) {
        if (Build.VERSION.SDK_INT >= 21) {
            int colorPrimary;
            Bitmap icon;
            String title = this.getTitle().toString();
            Drawable iconDrawable = this.getApplicationInfo().loadIcon(this.getPackageManager());
            Bitmap bitmap = icon = iconDrawable instanceof BitmapDrawable ? ((BitmapDrawable)iconDrawable).getBitmap() : null;
            if (position < this.getCount()) {
                try {
                    colorPrimary = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(position));
                }
                catch (Resources.NotFoundException e) {
                    colorPrimary = ContextCompat.getColor((Context)this, (int)this.getBackground(position));
                }
            } else {
                TypedValue typedValue = new TypedValue();
                TypedArray a = this.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorPrimary});
                colorPrimary = a.getColor(0, 0);
                a.recycle();
            }
            colorPrimary = ColorUtils.setAlphaComponent((int)colorPrimary, (int)255);
            this.setTaskDescription(new ActivityManager.TaskDescription(title, icon, colorPrimary));
        }
    }

    private void updateTaskDescription() {
        this.updateTaskDescription(0);
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.pager.setOnPageChangeListener(listener);
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.pager.addOnPageChangeListener(listener);
    }

    public void removeOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.pager.removeOnPageChangeListener(listener);
    }

    protected void addSlide(int location, Slide object) {
        this.adapter.addSlide(location, object);
    }

    protected boolean addSlide(Slide object) {
        return this.adapter.addSlide(object);
    }

    protected boolean addSlides(int location, @NonNull Collection<? extends Slide> collection) {
        return this.adapter.addSlides(location, collection);
    }

    protected boolean addSlides(@NonNull Collection<? extends Slide> collection) {
        return this.adapter.addSlides(collection);
    }

    protected void clearSlides() {
        this.adapter.clearSlides();
    }

    protected boolean containsSlide(Object object) {
        return this.adapter.containsSlide(object);
    }

    protected boolean containsSlides(@NonNull Collection<?> collection) {
        return this.adapter.containsSlides(collection);
    }

    protected Slide getSlide(int location) {
        return this.adapter.getSlide(location);
    }

    protected Fragment getItem(int position) {
        return this.adapter.getItem(position);
    }

    @ColorRes
    protected int getBackground(int position) {
        return this.adapter.getBackground(position);
    }

    @ColorRes
    protected int getBackgroundDark(int position) {
        return this.adapter.getBackgroundDark(position);
    }

    protected List<Slide> getSlides() {
        return this.adapter.getSlides();
    }

    protected int indexOfSlide(Object object) {
        return this.adapter.indexOfSlide(object);
    }

    protected boolean isEmpty() {
        return this.adapter.isEmpty();
    }

    protected int getCount() {
        return this.adapter.getCount();
    }

    protected int lastIndexOfSlide(Object object) {
        return this.adapter.lastIndexOfSlide(object);
    }

    protected Slide removeSlide(int location) {
        return this.adapter.removeSlide(location);
    }

    protected boolean removeSlide(Object object) {
        return this.adapter.removeSlide(object);
    }

    protected boolean removeSlides(@NonNull Collection<?> collection) {
        return this.adapter.removeSlides(collection);
    }

    protected boolean retainSlides(@NonNull Collection<?> collection) {
        return this.adapter.retainSlides(collection);
    }

    protected Slide setSlide(int location, Slide object) {
        return this.adapter.setSlide(location, object);
    }

    protected List<Slide> setSlides(List<? extends Slide> list) {
        return this.adapter.setSlides(list);
    }

    private class TaskDescriptionListener
    extends ViewPager.SimpleOnPageChangeListener {
        private TaskDescriptionListener() {
        }

        public void onPageSelected(int position) {
            IntroActivity.this.updateTaskDescription(position);
        }
    }

    private class FullscreenListener
    extends FadeableViewPager.SimpleOnOverscrollPageChangeListener {
        private FullscreenListener() {
        }

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if ((float)position + positionOffset > (float)(IntroActivity.this.adapter.getCount() - 1)) {
                IntroActivity.this.setFullscreenFlags(false);
            } else {
                IntroActivity.this.setFullscreenFlags(IntroActivity.this.fullscreen);
            }
        }
    }

    private class FinishListener
    extends FadeableViewPager.SimpleOnOverscrollPageChangeListener {
        private FinishListener() {
        }

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (position == IntroActivity.this.adapter.getCount()) {
                IntroActivity.this.finish();
                IntroActivity.this.overridePendingTransition(0, 0);
            }
        }
    }

    private class BackgroundListener
    extends FadeableViewPager.SimpleOnOverscrollPageChangeListener {
        private final ArgbEvaluator evaluator = new ArgbEvaluator();

        private BackgroundListener() {
        }

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int backgroundNext;
            int background;
            if (position == IntroActivity.this.getCount()) {
                background = 0;
                backgroundNext = 0;
            } else {
                background = ContextCompat.getColor((Context)IntroActivity.this, (int)IntroActivity.this.getBackground(position));
                backgroundNext = ContextCompat.getColor((Context)IntroActivity.this, (int)IntroActivity.this.getBackground(Math.min(position + 1, IntroActivity.this.getCount() - 1)));
                background = ColorUtils.setAlphaComponent((int)background, (int)255);
                backgroundNext = ColorUtils.setAlphaComponent((int)backgroundNext, (int)255);
            }
            if ((float)position + positionOffset >= (float)(IntroActivity.this.adapter.getCount() - 1)) {
                backgroundNext = ColorUtils.setAlphaComponent((int)background, (int)0);
            }
            IntroActivity.this.frame.setBackgroundColor(((Integer)this.evaluator.evaluate(positionOffset, (Object)background, (Object)backgroundNext)).intValue());
            if (Build.VERSION.SDK_INT >= 21) {
                int backgroundDarkNext;
                int backgroundDark;
                if (position == IntroActivity.this.getCount()) {
                    backgroundDark = 0;
                    backgroundDarkNext = 0;
                } else {
                    try {
                        backgroundDark = ContextCompat.getColor((Context)IntroActivity.this, (int)IntroActivity.this.getBackgroundDark(position));
                    }
                    catch (Resources.NotFoundException e) {
                        backgroundDark = ContextCompat.getColor((Context)IntroActivity.this, (int)R.color.mi_status_bar_background);
                    }
                    try {
                        backgroundDarkNext = ContextCompat.getColor((Context)IntroActivity.this, (int)IntroActivity.this.getBackgroundDark(Math.min(position + 1, IntroActivity.this.getCount() - 1)));
                    }
                    catch (Resources.NotFoundException e) {
                        backgroundDarkNext = ContextCompat.getColor((Context)IntroActivity.this, (int)R.color.mi_status_bar_background);
                    }
                }
                if ((float)position + positionOffset >= (float)(IntroActivity.this.adapter.getCount() - 1)) {
                    backgroundDarkNext = 0;
                }
                backgroundDark = (Integer)this.evaluator.evaluate(positionOffset, (Object)backgroundDark, (Object)backgroundDarkNext);
                IntroActivity.this.getWindow().setStatusBarColor(backgroundDark);
                if (position == IntroActivity.this.adapter.getCount()) {
                    IntroActivity.this.getWindow().setNavigationBarColor(0);
                } else if ((float)position + positionOffset >= (float)(IntroActivity.this.adapter.getCount() - 1)) {
                    TypedValue typedValue = new TypedValue();
                    TypedArray a = IntroActivity.this.obtainStyledAttributes(typedValue.data, new int[]{16843858});
                    int defaultNavigationBarColor = a.getColor(0, -16777216);
                    a.recycle();
                    int navigationBarColor = (Integer)this.evaluator.evaluate(positionOffset, (Object)defaultNavigationBarColor, (Object)0);
                    IntroActivity.this.getWindow().setNavigationBarColor(navigationBarColor);
                }
                if (Build.VERSION.SDK_INT >= 23) {
                    int systemUiVisibility = IntroActivity.this.getWindow().getDecorView().getSystemUiVisibility();
                    int flagLightStatusBar = 8192;
                    systemUiVisibility = ColorUtils.calculateLuminance((int)backgroundDark) > 0.4 ? (systemUiVisibility |= flagLightStatusBar) : (systemUiVisibility &= ~flagLightStatusBar);
                    IntroActivity.this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility);
                }
            }
        }
    }

    private class ButtonListener
    extends FadeableViewPager.SimpleOnOverscrollPageChangeListener {
        private ButtonListener() {
        }

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            ImageButton button;
            if (IntroActivity.this.buttonNext != null && IntroActivity.this.buttonNext instanceof ImageButton && (button = (ImageButton)IntroActivity.this.buttonNext).getDrawable() != null && button.getDrawable() instanceof LayerDrawable) {
                LayerDrawable drawable = (LayerDrawable)button.getDrawable();
                if ((float)position + positionOffset < (float)(IntroActivity.this.adapter.getCount() - 2)) {
                    drawable.getDrawable(0).setAlpha(255);
                    drawable.getDrawable(1).setAlpha(0);
                    IntroActivity.this.buttonSkip.setTranslationX(0.0f);
                    IntroActivity.this.buttonNext.setTranslationY(0.0f);
                    IntroActivity.this.pagerIndicator.setTranslationY(0.0f);
                } else if ((float)position + positionOffset < (float)(IntroActivity.this.adapter.getCount() - 1)) {
                    float offset = (float)position + positionOffset - (float)IntroActivity.this.adapter.getCount() + 2.0f;
                    drawable.getDrawable(0).setAlpha((int)(255.0f * (1.0f - offset)));
                    drawable.getDrawable(1).setAlpha((int)(255.0f * offset));
                    boolean rtl = Build.VERSION.SDK_INT >= 17 && IntroActivity.this.getResources().getConfiguration().getLayoutDirection() == 1;
                    IntroActivity.this.buttonSkip.setTranslationX(offset * (float)(rtl ? 1 : -1) * (float)IntroActivity.this.pager.getWidth());
                    IntroActivity.this.buttonNext.setTranslationY(0.0f);
                    IntroActivity.this.pagerIndicator.setTranslationY(0.0f);
                } else {
                    float offset = (float)position + positionOffset - (float)IntroActivity.this.adapter.getCount() + 1.0f;
                    IntroActivity.this.buttonSkip.setTranslationX((float)(-IntroActivity.this.pager.getWidth()));
                    IntroActivity.this.buttonNext.setTranslationY(offset * 2.0f * (float)IntroActivity.this.buttonSkip.getWidth());
                    IntroActivity.this.pagerIndicator.setTranslationY(offset * 2.0f * (float)IntroActivity.this.buttonSkip.getWidth());
                }
            }
        }
    }
}

