/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer.theme;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import com.heinrichreimersoftware.materialdrawer.R;

public class DrawerTheme {
    private final Context context;
    private int backgroundColor;
    private int statusBarBackgroundColor;
    private int textColorPrimary;
    private int textColorSecondary;
    private int textColorPrimaryInverse;
    private int textColorSecondaryInverse;
    private int highlightColor;

    public DrawerTheme(@NonNull DrawerTheme theme) {
        this.context = theme.context;
        this.backgroundColor = theme.getBackgroundColor();
        this.statusBarBackgroundColor = this.textColorPrimary = theme.getTextColorPrimary();
        this.textColorSecondary = theme.getTextColorSecondary();
        this.textColorPrimaryInverse = theme.getTextColorPrimaryInverse();
        this.textColorSecondaryInverse = theme.getTextColorSecondaryInverse();
        this.highlightColor = theme.getHighlightColor();
    }

    public DrawerTheme(Context context) {
        this.context = context;
        int[] attrs = new int[]{16842836, 16842806, 16842808, 16842809, 16842810, R.attr.colorAccent};
        TypedArray array = context.obtainStyledAttributes(attrs);
        this.backgroundColor = array.getColor(0, 0);
        this.statusBarBackgroundColor = ContextCompat.getColor((Context)context, (int)R.color.md_inset_foreground);
        this.textColorPrimary = array.getColor(1, 0);
        this.textColorSecondary = array.getColor(2, 0);
        this.textColorPrimaryInverse = array.getColor(3, 0);
        this.textColorSecondaryInverse = array.getColor(4, 0);
        this.highlightColor = array.getColor(5, 0);
        array.recycle();
    }

    public boolean isLightTheme() {
        return this.isLightColor(this.backgroundColor);
    }

    private boolean isLightColor(int color2) {
        return 1.0 - (0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2)) / 255.0 < 0.5;
    }

    public DrawerTheme setBackgroundColorRes(@ColorRes int backgroundColorRes) {
        this.backgroundColor = ContextCompat.getColor((Context)this.context, (int)backgroundColorRes);
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public DrawerTheme setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public DrawerTheme setStatusBarBackgroundColorRes(@ColorRes int statusBarBackgroundColorRes) {
        this.statusBarBackgroundColor = ContextCompat.getColor((Context)this.context, (int)statusBarBackgroundColorRes);
        return this;
    }

    public int getStatusBarBackgroundColor() {
        return this.statusBarBackgroundColor;
    }

    public DrawerTheme setStatusBarBackgroundColor(int statusBarBackgroundColor) {
        this.statusBarBackgroundColor = statusBarBackgroundColor;
        return this;
    }

    public DrawerTheme setTextColorPrimaryRes(@ColorRes int textColorPrimaryRes) {
        this.textColorPrimary = ContextCompat.getColor((Context)this.context, (int)textColorPrimaryRes);
        return this;
    }

    public int getTextColorPrimary() {
        return this.textColorPrimary;
    }

    public DrawerTheme setTextColorPrimary(int textColorPrimary) {
        this.textColorPrimary = textColorPrimary;
        return this;
    }

    public DrawerTheme setTextColorSecondaryRes(@ColorRes int textColorSecondaryRes) {
        this.textColorSecondary = ContextCompat.getColor((Context)this.context, (int)textColorSecondaryRes);
        return this;
    }

    public int getTextColorSecondary() {
        return this.textColorSecondary;
    }

    public DrawerTheme setTextColorSecondary(int textColorSecondary) {
        this.textColorSecondary = textColorSecondary;
        return this;
    }

    public DrawerTheme setTextColorPrimaryInverseRes(@ColorRes int textColorPrimaryInverseRes) {
        this.textColorPrimaryInverse = ContextCompat.getColor((Context)this.context, (int)textColorPrimaryInverseRes);
        return this;
    }

    public int getTextColorPrimaryInverse() {
        return this.textColorPrimaryInverse;
    }

    public DrawerTheme setTextColorPrimaryInverse(int textColorPrimaryInverse) {
        this.textColorPrimaryInverse = textColorPrimaryInverse;
        return this;
    }

    public DrawerTheme setTextColorSecondaryInverseRes(@ColorRes int textColorSecondaryInverseRes) {
        this.textColorSecondaryInverse = ContextCompat.getColor((Context)this.context, (int)textColorSecondaryInverseRes);
        return this;
    }

    public int getTextColorSecondaryInverse() {
        return this.textColorSecondaryInverse;
    }

    public DrawerTheme setTextColorSecondaryInverse(int textColorSecondaryInverse) {
        this.textColorSecondaryInverse = textColorSecondaryInverse;
        return this;
    }

    public DrawerTheme setHighlightColorRes(@ColorRes int highlightColorRes) {
        this.highlightColor = ContextCompat.getColor((Context)this.context, (int)highlightColorRes);
        return this;
    }

    public int getHighlightColor() {
        return this.highlightColor;
    }

    public DrawerTheme setHighlightColor(int highlightColor) {
        this.highlightColor = highlightColor;
        return this;
    }
}

