/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer.structure;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ArrayAdapter;
import com.heinrichreimersoftware.materialdrawer.drawable.RoundedAvatarDrawable;
import com.heinrichreimersoftware.materialdrawer.theme.DrawerTheme;

public class DrawerItem {
    public static final int ICON = 1;
    public static final int AVATAR = 2;
    public static final int SMALL_AVATAR = 3;
    public static final int SINGLE_LINE = 3;
    public static final int TWO_LINE = 4;
    public static final int THREE_LINE = 5;
    private DrawerTheme mDrawerTheme;
    private boolean mIsHeader = false;
    private long mId = -1L;
    private Drawable mImage = null;
    private int mImageMode = -1;
    private String mTextPrimary;
    private String mTextSecondary;
    private int mTextMode = -1;
    private OnItemClickListener mOnClickListener;
    private ArrayAdapter<DrawerItem> mAdapter;

    public DrawerItem setDrawerTheme(DrawerTheme theme) {
        this.mDrawerTheme = theme;
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem resetDrawerTheme(Context context) {
        this.mDrawerTheme = new DrawerTheme(context);
        this.notifyDataChanged();
        return this;
    }

    public DrawerTheme getDrawerTheme() {
        return this.mDrawerTheme;
    }

    public boolean hasDrawerTheme() {
        return this.mDrawerTheme != null;
    }

    public DrawerItem setIsHeader(boolean isHeader) {
        this.mIsHeader = isHeader;
        this.notifyDataChanged();
        return this;
    }

    public boolean isHeader() {
        return this.mIsHeader;
    }

    @Deprecated
    public DrawerItem setIsDivider(boolean isDivider) {
        this.setIsHeader(isDivider);
        return this;
    }

    @Deprecated
    public boolean isDivider() {
        return this.isHeader();
    }

    public DrawerItem setId(long id2) {
        this.mId = id2;
        return this;
    }

    public long getId() {
        return this.mId;
    }

    public DrawerItem setImage(Drawable image, int imageMode) {
        this.mImage = image;
        this.setImageMode(imageMode);
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem setImage(Drawable image) {
        this.setImage(image, 1);
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem setImage(Context context, Bitmap image, int imageMode) {
        return this.setImage((Drawable)new BitmapDrawable(context.getResources(), image), imageMode);
    }

    public DrawerItem setImage(Context context, Bitmap image) {
        return this.setImage((Drawable)new BitmapDrawable(context.getResources(), image));
    }

    public DrawerItem setRoundedImage(BitmapDrawable image, int imageMode) {
        return this.setImage(new RoundedAvatarDrawable(image.getBitmap()), imageMode);
    }

    public DrawerItem setRoundedImage(BitmapDrawable image) {
        return this.setImage(new RoundedAvatarDrawable(image.getBitmap()), 2);
    }

    public DrawerItem setRoundedImage(Context context, Bitmap image, int imageMode) {
        return this.setImage(new RoundedAvatarDrawable(new BitmapDrawable(context.getResources(), image).getBitmap()), imageMode);
    }

    public DrawerItem setRoundedImage(Context context, Bitmap image) {
        return this.setImage(new RoundedAvatarDrawable(new BitmapDrawable(context.getResources(), image).getBitmap()), 2);
    }

    public Drawable getImage() {
        return this.mImage;
    }

    public boolean hasImage() {
        return this.mImage != null;
    }

    public DrawerItem removeImage() {
        this.mImage = null;
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem setImageMode(int imageMode) {
        if (imageMode != 1 && imageMode != 2 && imageMode != 3) {
            throw new IllegalArgumentException("Image mode must be either ICON or AVATAR.");
        }
        this.mImageMode = imageMode;
        this.notifyDataChanged();
        return this;
    }

    public int getImageMode() {
        return this.mImageMode;
    }

    public boolean hasImageMode() {
        return this.mImageMode > 0;
    }

    public DrawerItem resetImageMode() {
        this.mImageMode = 1;
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem setTextPrimary(String textPrimary) {
        this.mTextPrimary = textPrimary;
        this.notifyDataChanged();
        return this;
    }

    public String getTextPrimary() {
        return this.mTextPrimary;
    }

    public boolean hasTextPrimary() {
        return this.mTextPrimary != null && !this.mTextPrimary.equals("");
    }

    public DrawerItem removeTextPrimary() {
        this.mTextPrimary = null;
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem setTextSecondary(String textSecondary, int textMode) {
        this.mTextSecondary = textSecondary;
        this.setTextMode(textMode);
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem setTextSecondary(String textSecondary) {
        this.setTextSecondary(textSecondary, 4);
        return this;
    }

    public String getTextSecondary() {
        return this.mTextSecondary;
    }

    public boolean hasTextSecondary() {
        return this.mTextSecondary != null && !this.mTextSecondary.equals("");
    }

    public DrawerItem removeTextSecondary() {
        this.mTextSecondary = null;
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem setTextMode(int textMode) {
        if (textMode != 3 && textMode != 4 && textMode != 5) {
            throw new IllegalArgumentException("Image mode must be either SINGLE_LINE, TWO_LINE or THREE_LINE.");
        }
        this.mTextMode = textMode;
        this.notifyDataChanged();
        return this;
    }

    public int getTextMode() {
        return this.mTextMode;
    }

    public boolean hasTextMode() {
        return this.mTextMode > 0;
    }

    public DrawerItem resetTextMode() {
        this.mTextMode = 3;
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem setOnItemClickListener(OnItemClickListener listener) {
        this.mOnClickListener = listener;
        this.notifyDataChanged();
        return this;
    }

    public OnItemClickListener getOnItemClickListener() {
        return this.mOnClickListener;
    }

    public boolean hasOnItemClickListener() {
        return this.mOnClickListener != null;
    }

    public DrawerItem removeOnItemClickListener() {
        this.mOnClickListener = null;
        this.notifyDataChanged();
        return this;
    }

    public DrawerItem attachTo(ArrayAdapter<DrawerItem> adapter) {
        this.mAdapter = adapter;
        return this;
    }

    public DrawerItem detach() {
        this.mAdapter = null;
        return this;
    }

    protected void notifyDataChanged() {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public static interface OnItemClickListener {
        public void onClick(DrawerItem var1, long var2, int var4);
    }
}

