/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer.adapter;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.heinrichreimersoftware.materialdrawer.R;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerProfile;
import com.heinrichreimersoftware.materialdrawer.theme.DrawerTheme;
import java.util.ArrayList;
import java.util.List;

public class DrawerProfileAdapter
extends ArrayAdapter<DrawerProfile> {
    private DrawerTheme drawerTheme;

    public DrawerProfileAdapter(Context context, List<DrawerProfile> dataSet) {
        super(context, R.layout.md_drawer_item, dataSet);
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        DrawerProfile drawerProfile = (DrawerProfile)this.getItem(position);
        DrawerTheme drawerTheme = this.drawerTheme;
        assert (drawerProfile != null);
        if (drawerProfile.hasDrawerTheme()) {
            drawerTheme = drawerProfile.getDrawerTheme();
        }
        if (convertView == null || !(convertView instanceof RelativeLayout)) {
            convertView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.md_drawer_item, parent, false);
        }
        ViewHolder viewHolder = new ViewHolder(convertView);
        int textColorPrimary = drawerTheme.getTextColorPrimary();
        if (drawerTheme.isLightTheme()) {
            viewHolder.getRoot().setForeground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.md_selector_light));
        } else {
            viewHolder.getRoot().setForeground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.md_selector_dark));
        }
        if (drawerTheme.getBackgroundColor() != 0) {
            viewHolder.getRoot().setBackgroundColor(drawerTheme.getBackgroundColor());
        } else {
            viewHolder.getRoot().setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170445));
        }
        if (position == 0) {
            viewHolder.getRoot().setSelected(true);
            viewHolder.getRoot().setClickable(false);
            textColorPrimary = drawerTheme.getHighlightColor();
        } else {
            viewHolder.getRoot().setSelected(false);
            viewHolder.getRoot().setClickable(true);
        }
        if (drawerProfile.hasAvatar()) {
            viewHolder.getImageView().setVisibility(0);
            viewHolder.getImageView().setImageDrawable(drawerProfile.getAvatar());
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)viewHolder.getImageView().getLayoutParams();
            layoutParams.height = this.getContext().getResources().getDimensionPixelSize(R.dimen.md_avatar_size);
            layoutParams.width = this.getContext().getResources().getDimensionPixelSize(R.dimen.md_baseline_content) - this.getContext().getResources().getDimensionPixelSize(R.dimen.md_baseline);
            int imagePaddingEnd = this.getContext().getResources().getDimensionPixelSize(R.dimen.md_baseline_content) - this.getContext().getResources().getDimensionPixelSize(R.dimen.md_baseline) - this.getContext().getResources().getDimensionPixelSize(R.dimen.md_avatar_size);
            if (Build.VERSION.SDK_INT >= 17) {
                viewHolder.getImageView().setPaddingRelative(0, 0, imagePaddingEnd, 0);
            } else {
                viewHolder.getImageView().setPadding(0, 0, imagePaddingEnd, 0);
            }
        } else {
            viewHolder.getImageView().setVisibility(8);
        }
        if (drawerProfile.hasName()) {
            viewHolder.getTextViewPrimary().setText((CharSequence)drawerProfile.getName());
            viewHolder.getTextViewPrimary().setTextColor(textColorPrimary);
            if (drawerProfile.hasDescription()) {
                viewHolder.getTextViewSecondary().setText((CharSequence)drawerProfile.getDescription());
                viewHolder.getTextViewSecondary().setTextColor(drawerTheme.getTextColorSecondary());
                viewHolder.getTextViewSecondary().setVisibility(0);
                viewHolder.getTextViewSecondary().setMaxLines(1);
            } else {
                viewHolder.getTextViewSecondary().setVisibility(8);
            }
        } else if (drawerProfile.hasDescription()) {
            viewHolder.getTextViewPrimary().setText((CharSequence)drawerProfile.getDescription());
            viewHolder.getTextViewPrimary().setTextColor(textColorPrimary);
            viewHolder.getTextViewSecondary().setVisibility(8);
        }
        return convertView;
    }

    public boolean isEnabled(int position) {
        return position != 0;
    }

    public void setDrawerTheme(DrawerTheme theme) {
        this.drawerTheme = theme;
        this.notifyDataSetChanged();
    }

    public List<DrawerProfile> getItems() {
        ArrayList<DrawerProfile> items = new ArrayList<DrawerProfile>();
        for (int i = 0; i < this.getCount(); ++i) {
            items.add((DrawerProfile)this.getItem(i));
        }
        return items;
    }

    private static class ViewHolder {
        private final FrameLayout mRoot;
        private final ImageView mImageView;
        private final TextView mTextViewPrimary;
        private final TextView mTextViewSecondary;

        public ViewHolder(View root) {
            this.mRoot = (FrameLayout)root;
            this.mImageView = (ImageView)root.findViewById(R.id.mdImage);
            this.mTextViewPrimary = (TextView)root.findViewById(R.id.mdTextPrimary);
            this.mTextViewSecondary = (TextView)root.findViewById(R.id.mdTextSecondary);
        }

        public FrameLayout getRoot() {
            return this.mRoot;
        }

        public ImageView getImageView() {
            return this.mImageView;
        }

        public TextView getTextViewPrimary() {
            return this.mTextViewPrimary;
        }

        public TextView getTextViewSecondary() {
            return this.mTextViewSecondary;
        }
    }
}

