/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer.adapter;

import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.heinrichreimersoftware.materialdrawer.R;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerHeaderItem;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerItem;
import com.heinrichreimersoftware.materialdrawer.theme.DrawerTheme;
import java.util.ArrayList;
import java.util.List;

public class DrawerAdapter
extends ArrayAdapter<DrawerItem> {
    private int selectedPosition = -1;
    private DrawerTheme drawerTheme;

    public DrawerAdapter(Context context, List<DrawerItem> dataSet) {
        super(context, R.layout.md_drawer_item, dataSet);
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        DrawerItem drawerItem = (DrawerItem)this.getItem(position);
        DrawerTheme drawerTheme = this.drawerTheme;
        assert (drawerItem != null);
        if (drawerItem.hasDrawerTheme()) {
            drawerTheme = drawerItem.getDrawerTheme();
        }
        if (drawerItem.isHeader()) {
            if (convertView == null || convertView instanceof LinearLayout) {
                convertView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.md_drawer_header_item, parent, false);
            }
            HeaderViewHolder viewHolder = new HeaderViewHolder(convertView);
            if (drawerTheme.isLightTheme()) {
                viewHolder.getHeaderDivider().setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.md_divider_light));
            } else {
                viewHolder.getHeaderDivider().setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.md_divider_dark));
            }
            DrawerHeaderItem drawerHeaderItem = (DrawerHeaderItem)drawerItem;
            viewHolder.getHeaderRoot().setBackgroundColor(drawerTheme.getBackgroundColor());
            if (drawerHeaderItem.hasTitle()) {
                viewHolder.getHeaderTitleRoot().setVisibility(0);
                viewHolder.getHeaderRoot().setPadding(0, this.getContext().getResources().getDimensionPixelSize(R.dimen.md_divider_margin), 0, 0);
                viewHolder.getHeaderTitle().setText((CharSequence)drawerHeaderItem.getTitle());
                viewHolder.getHeaderTitle().setTextColor(drawerTheme.getTextColorSecondary());
            } else {
                viewHolder.getHeaderTitleRoot().setVisibility(8);
                viewHolder.getHeaderRoot().setPadding(0, this.getContext().getResources().getDimensionPixelSize(R.dimen.md_divider_margin), 0, this.getContext().getResources().getDimensionPixelSize(R.dimen.md_divider_margin));
            }
        } else {
            if (convertView == null || !(convertView instanceof RelativeLayout)) {
                convertView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.md_drawer_item, parent, false);
            }
            ViewHolder viewHolder = new ViewHolder(convertView);
            int iconTint = -1;
            int textColorPrimary = drawerTheme.getTextColorPrimary();
            if (drawerTheme.isLightTheme()) {
                viewHolder.getRoot().setForeground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.md_selector_light));
            } else {
                viewHolder.getRoot().setForeground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.md_selector_dark));
            }
            if (drawerTheme.getBackgroundColor() != 0) {
                viewHolder.getRoot().setBackgroundColor(drawerTheme.getBackgroundColor());
            } else {
                viewHolder.getRoot().setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170445));
            }
            if (position == this.selectedPosition) {
                viewHolder.getRoot().setSelected(true);
                textColorPrimary = iconTint = drawerTheme.getHighlightColor();
            } else {
                viewHolder.getRoot().setSelected(false);
            }
            if (drawerItem.hasImage()) {
                int imageSize;
                viewHolder.getImageView().setVisibility(0);
                viewHolder.getImageView().setImageDrawable(drawerItem.getImage());
                if (drawerItem.getImageMode() == 2) {
                    imageSize = this.getContext().getResources().getDimensionPixelSize(R.dimen.md_avatar_size);
                } else {
                    imageSize = this.getContext().getResources().getDimensionPixelSize(R.dimen.md_icon_size);
                    if (iconTint != -1 && drawerItem.getImageMode() == 1) {
                        viewHolder.getImageView().setColorFilter(iconTint, PorterDuff.Mode.SRC_IN);
                    } else {
                        viewHolder.getImageView().getDrawable().clearColorFilter();
                    }
                }
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)viewHolder.getImageView().getLayoutParams();
                layoutParams.height = imageSize;
                layoutParams.width = this.getContext().getResources().getDimensionPixelSize(R.dimen.md_baseline_content) - this.getContext().getResources().getDimensionPixelSize(R.dimen.md_baseline);
                int imagePaddingEnd = this.getContext().getResources().getDimensionPixelSize(R.dimen.md_baseline_content) - this.getContext().getResources().getDimensionPixelSize(R.dimen.md_baseline) - imageSize;
                if (Build.VERSION.SDK_INT >= 17) {
                    viewHolder.getImageView().setPaddingRelative(0, 0, imagePaddingEnd, 0);
                } else {
                    viewHolder.getImageView().setPadding(0, 0, imagePaddingEnd, 0);
                }
            } else {
                viewHolder.getImageView().setVisibility(8);
            }
            if (drawerItem.hasTextPrimary()) {
                viewHolder.getTextViewPrimary().setText((CharSequence)drawerItem.getTextPrimary());
                viewHolder.getTextViewPrimary().setTextColor(textColorPrimary);
                if (drawerItem.hasTextSecondary() && (drawerItem.getTextMode() == 4 || drawerItem.getTextMode() == 5)) {
                    viewHolder.getTextViewSecondary().setText((CharSequence)drawerItem.getTextSecondary());
                    viewHolder.getTextViewSecondary().setTextColor(drawerTheme.getTextColorSecondary());
                    viewHolder.getTextViewSecondary().setVisibility(0);
                    if (drawerItem.getTextMode() == 5) {
                        viewHolder.getTextViewSecondary().setMaxLines(2);
                    } else {
                        viewHolder.getTextViewSecondary().setMaxLines(1);
                    }
                } else {
                    viewHolder.getTextViewSecondary().setVisibility(8);
                }
            } else if (drawerItem.hasTextSecondary()) {
                viewHolder.getTextViewPrimary().setText((CharSequence)drawerItem.getTextPrimary());
                viewHolder.getTextViewPrimary().setTextColor(textColorPrimary);
                viewHolder.getTextViewSecondary().setVisibility(8);
            }
        }
        return convertView;
    }

    public boolean isEnabled(int position) {
        DrawerItem item = (DrawerItem)this.getItem(position);
        return item != null && item.hasOnItemClickListener();
    }

    public void setDrawerTheme(DrawerTheme theme) {
        this.drawerTheme = theme;
        this.notifyDataSetChanged();
    }

    public List<DrawerItem> getItems() {
        ArrayList<DrawerItem> items = new ArrayList<DrawerItem>();
        for (int i = 0; i < this.getCount(); ++i) {
            items.add((DrawerItem)this.getItem(i));
        }
        return items;
    }

    public void select(int position) {
        if (position >= 0 && position < this.getCount()) {
            this.selectedPosition = position;
            this.notifyDataSetChanged();
        } else {
            this.selectedPosition = -1;
            this.notifyDataSetChanged();
        }
    }

    public void clearSelection() {
        this.select(-1);
    }

    public int getSelectedPosition() {
        return this.selectedPosition;
    }

    private static class HeaderViewHolder {
        private final LinearLayout mHeaderRoot;
        private final View mHeaderDivider;
        private final LinearLayout mHeaderTitleRoot;
        private final TextView mHeaderTitle;

        public HeaderViewHolder(View root) {
            this.mHeaderRoot = (LinearLayout)root;
            this.mHeaderDivider = root.findViewById(R.id.mdDivider);
            this.mHeaderTitleRoot = (LinearLayout)root.findViewById(R.id.mdHeaderTitleRoot);
            this.mHeaderTitle = (TextView)root.findViewById(R.id.mdHeaderTitle);
        }

        public LinearLayout getHeaderRoot() {
            return this.mHeaderRoot;
        }

        public View getHeaderDivider() {
            return this.mHeaderDivider;
        }

        public LinearLayout getHeaderTitleRoot() {
            return this.mHeaderTitleRoot;
        }

        public TextView getHeaderTitle() {
            return this.mHeaderTitle;
        }
    }

    private static class ViewHolder {
        private final FrameLayout mRoot;
        private final ImageView mImageView;
        private final TextView mTextViewPrimary;
        private final TextView mTextViewSecondary;

        public ViewHolder(View root) {
            this.mRoot = (FrameLayout)root;
            this.mImageView = (ImageView)root.findViewById(R.id.mdImage);
            this.mTextViewPrimary = (TextView)root.findViewById(R.id.mdTextPrimary);
            this.mTextViewSecondary = (TextView)root.findViewById(R.id.mdTextSecondary);
        }

        public FrameLayout getRoot() {
            return this.mRoot;
        }

        public ImageView getImageView() {
            return this.mImageView;
        }

        public TextView getTextViewPrimary() {
            return this.mTextViewPrimary;
        }

        public TextView getTextViewSecondary() {
            return this.mTextViewSecondary;
        }
    }
}

