/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.DrawerLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.heinrichreimersoftware.materialdrawer.DrawerView;
import com.heinrichreimersoftware.materialdrawer.R;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerItem;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerProfile;
import com.heinrichreimersoftware.materialdrawer.theme.DrawerTheme;
import java.util.List;

public class DrawerFrameLayout
extends DrawerLayout {
    private final DrawerView mDrawer;

    public DrawerFrameLayout(Context context) {
        this(context, null);
    }

    public DrawerFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DrawerFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        DrawerFrameLayout.inflate((Context)context, (int)R.layout.md_drawer_frame_layout, (ViewGroup)this);
        this.mDrawer = (DrawerView)this.findViewById(R.id.mdDrawer);
        this.setDrawerShadow(R.drawable.md_drawer_shadow, 0x800003);
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.colorPrimaryDark});
        int colorPrimaryDark = a.getColor(0, 0);
        if (colorPrimaryDark != 0) {
            this.setStatusBarBackgroundColor(colorPrimaryDark);
        } else {
            this.setStatusBarBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170444));
        }
        a = this.getContext().obtainStyledAttributes(attrs, new int[]{R.attr.drawerMaxWidth});
        int drawerMaxWidth = a.getDimensionPixelSize(0, 0);
        if (drawerMaxWidth != 0) {
            this.setDrawerMaxWidth(drawerMaxWidth);
        } else {
            this.resetDrawerMaxWidth();
        }
        a.recycle();
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, 0, params);
    }

    public boolean getLoggingEnabled() {
        return this.mDrawer.getLoggingEnabled();
    }

    public DrawerFrameLayout setLoggingEnabled(boolean loggingEnabled) {
        this.mDrawer.setLoggingEnabled(loggingEnabled);
        return this;
    }

    public DrawerFrameLayout resetDrawerTheme() {
        this.mDrawer.resetDrawerTheme();
        return this;
    }

    public DrawerTheme getDrawerTheme() {
        return this.mDrawer.getDrawerTheme();
    }

    public DrawerFrameLayout setDrawerTheme(DrawerTheme theme) {
        this.mDrawer.setDrawerTheme(theme);
        return this;
    }

    public DrawerFrameLayout setDrawerMaxWidthResource(int drawerMaxWidthResource) {
        this.mDrawer.setDrawerMaxWidthResource(drawerMaxWidthResource);
        return this;
    }

    public DrawerFrameLayout resetDrawerMaxWidth() {
        this.mDrawer.resetDrawerMaxWidth();
        return this;
    }

    public int getDrawerMaxWidth() {
        return this.mDrawer.getDrawerMaxWidth();
    }

    public DrawerFrameLayout setDrawerMaxWidth(int drawerMaxWidth) {
        this.mDrawer.setDrawerMaxWidth(drawerMaxWidth);
        return this;
    }

    public DrawerFrameLayout addProfile(DrawerProfile profile) {
        this.mDrawer.addProfile(profile);
        return this;
    }

    public List<DrawerProfile> getProfiles() {
        return this.mDrawer.getProfiles();
    }

    public DrawerProfile findProfileById(long id2) {
        return this.mDrawer.findProfileById(id2);
    }

    public DrawerFrameLayout selectProfile(DrawerProfile profile) {
        this.mDrawer.selectProfile(profile);
        return this;
    }

    public DrawerFrameLayout selectProfileById(long id2) {
        this.mDrawer.selectProfileById(id2);
        return this;
    }

    public DrawerFrameLayout removeProfile(DrawerProfile profile) {
        this.mDrawer.removeProfile(profile);
        return this;
    }

    public DrawerFrameLayout removeProfileById(long id2) {
        this.mDrawer.removeProfileById(id2);
        return this;
    }

    public DrawerFrameLayout clearProfiles() {
        this.mDrawer.clearProfiles();
        return this;
    }

    public DrawerProfile.OnProfileClickListener getOnProfileClickListener() {
        return this.mDrawer.getOnProfileClickListener();
    }

    public DrawerFrameLayout setOnProfileClickListener(DrawerProfile.OnProfileClickListener listener) {
        this.mDrawer.setOnProfileClickListener(listener);
        return this;
    }

    public boolean hasOnProfileClickListener() {
        return this.mDrawer.hasOnProfileClickListener();
    }

    public DrawerFrameLayout removeOnProfileClickListener() {
        this.mDrawer.removeOnProfileClickListener();
        return this;
    }

    public DrawerProfile.OnProfileSwitchListener getOnProfileSwitchListener() {
        return this.mDrawer.getOnProfileSwitchListener();
    }

    public DrawerFrameLayout setOnProfileSwitchListener(DrawerProfile.OnProfileSwitchListener listener) {
        this.mDrawer.setOnProfileSwitchListener(listener);
        return this;
    }

    public boolean hasOnProfileSwitchListener() {
        return this.mDrawer.hasOnProfileSwitchListener();
    }

    public DrawerFrameLayout removeOnProfileSwitchListener() {
        this.mDrawer.removeOnProfileSwitchListener();
        return this;
    }

    public DrawerFrameLayout addItems(List<DrawerItem> items) {
        this.mDrawer.addItems(items);
        return this;
    }

    public DrawerFrameLayout addItems(DrawerItem ... items) {
        this.mDrawer.addItems(items);
        return this;
    }

    public DrawerFrameLayout addItem(DrawerItem item) {
        this.mDrawer.addItem(item);
        return this;
    }

    public DrawerFrameLayout addDivider() {
        this.mDrawer.addDivider();
        return this;
    }

    public List<DrawerItem> getItems() {
        return this.mDrawer.getItems();
    }

    public DrawerItem getItem(int position) {
        return this.mDrawer.getItem(position);
    }

    public DrawerItem findItemById(long id2) {
        return this.mDrawer.findItemById(id2);
    }

    public void selectItem(int position) {
        this.mDrawer.selectItem(position);
    }

    public int getSelectedPosition() {
        return this.mDrawer.getSelectedPosition();
    }

    public void selectItemById(long id2) {
        this.mDrawer.selectItemById(id2);
    }

    public DrawerFrameLayout removeItem(DrawerItem item) {
        this.mDrawer.removeItem(item);
        return this;
    }

    public DrawerFrameLayout removeItemById(long id2) {
        this.mDrawer.removeItemById(id2);
        return this;
    }

    public DrawerFrameLayout removeItem(int position) {
        this.mDrawer.removeItem(position);
        return this;
    }

    public DrawerFrameLayout clearItems() {
        this.mDrawer.clearItems();
        return this;
    }

    public DrawerItem.OnItemClickListener getOnItemClickListener() {
        return this.mDrawer.getOnItemClickListener();
    }

    public DrawerFrameLayout setOnItemClickListener(DrawerItem.OnItemClickListener listener) {
        this.mDrawer.setOnItemClickListener(listener);
        return this;
    }

    public boolean hasOnItemClickListener() {
        return this.mDrawer.hasOnItemClickListener();
    }

    public DrawerFrameLayout removeOnItemClickListener() {
        this.mDrawer.removeOnItemClickListener();
        return this;
    }

    public DrawerFrameLayout addFixedItems(List<DrawerItem> items) {
        this.mDrawer.addFixedItems(items);
        return this;
    }

    public DrawerFrameLayout addFixedItems(DrawerItem ... items) {
        this.mDrawer.addFixedItems(items);
        return this;
    }

    public DrawerFrameLayout addFixedItem(DrawerItem item) {
        this.mDrawer.addFixedItem(item);
        return this;
    }

    public DrawerFrameLayout addFixedDivider() {
        this.mDrawer.addFixedDivider();
        return this;
    }

    public List<DrawerItem> getFixedItems() {
        return this.mDrawer.getFixedItems();
    }

    public DrawerItem getFixedItem(int position) {
        return this.mDrawer.getFixedItem(position);
    }

    public DrawerItem findFixedItemById(long id2) {
        return this.mDrawer.findFixedItemById(id2);
    }

    public void selectFixedItem(int position) {
        this.mDrawer.selectFixedItem(position);
    }

    public int getSelectedFixedPosition() {
        return this.mDrawer.getSelectedFixedPosition();
    }

    public void selectFixedItemById(long id2) {
        this.mDrawer.selectFixedItemById(id2);
    }

    public DrawerFrameLayout removeFixedItem(DrawerItem item) {
        this.mDrawer.removeFixedItem(item);
        return this;
    }

    public DrawerFrameLayout removeFixedItem(int position) {
        this.mDrawer.removeFixedItem(position);
        return this;
    }

    public DrawerFrameLayout removeFixedItemById(long id2) {
        this.mDrawer.removeFixedItemById(id2);
        return this;
    }

    public DrawerFrameLayout clearFixedItems() {
        this.mDrawer.clearFixedItems();
        return this;
    }

    public DrawerItem.OnItemClickListener getOnFixedItemClickListener() {
        return this.mDrawer.getOnFixedItemClickListener();
    }

    public DrawerFrameLayout setOnFixedItemClickListener(DrawerItem.OnItemClickListener listener) {
        this.mDrawer.setOnFixedItemClickListener(listener);
        return this;
    }

    public boolean hasOnFixedItemClickListener() {
        return this.mDrawer.hasOnFixedItemClickListener();
    }

    public DrawerFrameLayout removeOnFixedItemClickListener() {
        this.mDrawer.removeOnFixedItemClickListener();
        return this;
    }

    public void openDrawer() {
        this.openDrawer((View)this.mDrawer);
    }

    public void closeDrawer() {
        this.closeDrawer((View)this.mDrawer);
    }
}

