/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.InvalidCredentialsException;
import com.healthmarketscience.jackcess.PasswordCallback;
import com.healthmarketscience.jackcess.impl.BaseJetCryptCodecHandler;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CodecHandler;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.JetCryptCodecHandler;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.util.StreamCipherCompat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.KeyParameter;

public class MSISAMCryptCodecHandler
extends BaseJetCryptCodecHandler {
    private static final int SALT_OFFSET = 114;
    private static final int CRYPT_CHECK_START = 745;
    private static final int ENCRYPTION_FLAGS_OFFSET = 664;
    private static final int SALT_LENGTH = 4;
    private static final int PASSWORD_LENGTH = 40;
    private static final int USE_SHA1 = 32;
    private static final int PASSWORD_DIGEST_LENGTH = 16;
    private static final int MSISAM_MAX_ENCRYPTED_PAGE = 14;
    private static final int NEW_ENCRYPTION = 6;
    private static final int TRAILING_PWD_LEN = 20;
    private final byte[] _baseHash;

    MSISAMCryptCodecHandler(PageChannel channel, String password, Charset charset, ByteBuffer buffer) throws IOException {
        super(channel, null);
        byte[] salt = ByteUtil.getBytes((ByteBuffer)buffer, (int)114, (int)8);
        byte[] pwdDigest = MSISAMCryptCodecHandler.createPasswordDigest(buffer, password, charset);
        byte[] baseSalt = ByteUtil.copyOf((byte[])salt, (int)4);
        this.verifyPassword(buffer, ByteUtil.concat((byte[])pwdDigest, (byte[])salt), baseSalt);
        this._baseHash = ByteUtil.concat((byte[])pwdDigest, (byte[])baseSalt);
    }

    public static CodecHandler create(PasswordCallback callback, PageChannel channel, Charset charset) throws IOException {
        ByteBuffer buffer = MSISAMCryptCodecHandler.readHeaderPage(channel);
        if ((buffer.get(664) & 6) != 0) {
            return new MSISAMCryptCodecHandler(channel, callback.getPassword(), charset, buffer);
        }
        return new JetCryptCodecHandler(channel, MSISAMCryptCodecHandler.getOldDecryptionKey(buffer, channel.getFormat())){

            protected int getMaxEncodedPage() {
                return 14;
            }
        };
    }

    protected KeyParameter computeCipherParams(int pageNumber) {
        return new KeyParameter(MSISAMCryptCodecHandler.applyPageNumber(this._baseHash, 16, pageNumber));
    }

    protected int getMaxEncodedPage() {
        return 14;
    }

    private void verifyPassword(ByteBuffer buffer, byte[] testEncodingKey, byte[] testBytes) {
        StreamCipherCompat engine = MSISAMCryptCodecHandler.decryptInit(this.getStreamCipher(), (CipherParameters)new KeyParameter(testEncodingKey));
        byte[] encrypted4BytesCheck = MSISAMCryptCodecHandler.getPasswordTestBytes(buffer);
        if (MSISAMCryptCodecHandler.isBlankKey(encrypted4BytesCheck)) {
            return;
        }
        byte[] decrypted4BytesCheck = MSISAMCryptCodecHandler.decryptBytes(engine, encrypted4BytesCheck);
        if (!Arrays.equals(decrypted4BytesCheck, testBytes)) {
            throw new InvalidCredentialsException("Incorrect password provided");
        }
    }

    private static byte[] createPasswordDigest(ByteBuffer buffer, String password, Charset charset) {
        SHA1Digest digest = (buffer.get(664) & 0x20) != 0 ? new SHA1Digest() : new MD5Digest();
        byte[] passwordBytes = new byte[40];
        if (password != null) {
            ByteBuffer bb = ColumnImpl.encodeUncompressedText((CharSequence)password.toUpperCase(), (Charset)charset);
            bb.get(passwordBytes, 0, Math.min(passwordBytes.length, bb.remaining()));
        }
        byte[] digestBytes = MSISAMCryptCodecHandler.hash((Digest)digest, passwordBytes, 16);
        return digestBytes;
    }

    private static byte[] getOldDecryptionKey(ByteBuffer buffer, JetFormat format) {
        byte[] encodingKey = ByteUtil.getBytes((ByteBuffer)buffer, (int)114, (int)4);
        byte[] fullHashData = ByteUtil.getBytes((ByteBuffer)buffer, (int)format.OFFSET_PASSWORD, (int)(format.SIZE_PASSWORD * 2));
        byte[] pwdMask = DatabaseImpl.getPasswordMask((ByteBuffer)buffer, (JetFormat)format);
        if (pwdMask != null) {
            for (int i = 0; i < format.SIZE_PASSWORD; ++i) {
                int n = i;
                fullHashData[n] = (byte)(fullHashData[n] ^ pwdMask[i % pwdMask.length]);
            }
            int trailingOffset = fullHashData.length - 20;
            for (int i = 0; i < 20; ++i) {
                int n = trailingOffset + i;
                fullHashData[n] = (byte)(fullHashData[n] ^ pwdMask[i % pwdMask.length]);
            }
        }
        byte[] hashData = new byte[format.SIZE_PASSWORD];
        for (int pos = 0; pos < format.SIZE_PASSWORD; ++pos) {
            hashData[pos] = fullHashData[pos * 2];
        }
        MSISAMCryptCodecHandler.hashSalt(encodingKey, hashData);
        byte[] jetHeader = ByteUtil.getBytes((ByteBuffer)buffer, (int)4, (int)15);
        MSISAMCryptCodecHandler.hashSalt(encodingKey, jetHeader);
        return encodingKey;
    }

    private static byte[] getPasswordTestBytes(ByteBuffer buffer) {
        int cryptCheckOffset = ByteUtil.getUnsignedByte((ByteBuffer)buffer, (int)114);
        return ByteUtil.getBytes((ByteBuffer)buffer, (int)(745 + cryptCheckOffset), (int)4);
    }

    private static void hashSalt(byte[] salt, byte[] hashData) {
        ByteBuffer bb = MSISAMCryptCodecHandler.wrap(salt);
        int hash = bb.getInt();
        for (int pos = 0; pos < hashData.length; ++pos) {
            int tmp = hashData[pos] & 0xFF;
            hash ^= (tmp <<= pos % 24);
        }
        bb.rewind();
        bb.putInt(hash);
    }
}

