/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.BaseCryptCodecHandler;
import com.healthmarketscience.jackcess.CodecHandler;
import com.healthmarketscience.jackcess.DefaultCodecProvider;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.params.KeyParameter;

public class JetCryptCodecHandler
extends BaseCryptCodecHandler {
    static final int ENCODING_KEY_LENGTH = 4;
    private final byte[] _encodingKey;

    JetCryptCodecHandler(byte[] encodingKey) {
        this._encodingKey = encodingKey;
    }

    public static CodecHandler create(PageChannel channel) throws IOException {
        ByteBuffer buffer = JetCryptCodecHandler.readHeaderPage(channel);
        JetFormat format = channel.getFormat();
        byte[] encodingKey = new byte[4];
        buffer.position(format.OFFSET_ENCODING_KEY);
        buffer.get(encodingKey);
        boolean clearData = true;
        for (byte byteVal : encodingKey) {
            if (byteVal == 0) continue;
            clearData = false;
        }
        return clearData ? DefaultCodecProvider.DUMMY_HANDLER : new JetCryptCodecHandler(encodingKey);
    }

    public void decodePage(ByteBuffer buffer, int pageNumber) {
        if (pageNumber == 0 || pageNumber > this.getMaxEncodedPage()) {
            return;
        }
        byte[] key = JetCryptCodecHandler.applyPageNumber(this._encodingKey, 0, pageNumber);
        this.decodePage(buffer, new KeyParameter(key));
    }

    protected int getMaxEncodedPage() {
        return Integer.MAX_VALUE;
    }
}

