/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.CodecHandler;
import com.healthmarketscience.jackcess.CodecProvider;
import com.healthmarketscience.jackcess.DefaultCodecProvider;
import com.healthmarketscience.jackcess.JetCryptCodecHandler;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.MSISAMCryptCodecHandler;
import com.healthmarketscience.jackcess.PageChannel;
import java.io.IOException;
import java.nio.charset.Charset;

public class CryptCodecProvider
implements CodecProvider {
    private String _password;

    public CryptCodecProvider() {
        this(null);
    }

    public CryptCodecProvider(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String newPassword) {
        this._password = newPassword;
    }

    public CodecHandler createHandler(PageChannel channel, Charset charset) throws IOException {
        JetFormat format = channel.getFormat();
        switch (format.CODEC_TYPE) {
            case NONE: {
                return DefaultCodecProvider.DUMMY_HANDLER;
            }
            case JET: {
                return JetCryptCodecHandler.create(channel);
            }
            case MSISAM: {
                return MSISAMCryptCodecHandler.create(this.getPassword(), channel, charset);
            }
        }
        throw new RuntimeException("Unknown codec type " + format.CODEC_TYPE);
    }
}

