/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.CodecHandler;
import com.healthmarketscience.jackcess.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;

public abstract class BaseCryptCodecHandler
implements CodecHandler {
    private RC4Engine _engine;

    protected BaseCryptCodecHandler() {
    }

    protected final RC4Engine getEngine() {
        if (this._engine == null) {
            this._engine = new RC4Engine();
        }
        return this._engine;
    }

    protected void decodePage(ByteBuffer buffer, KeyParameter params) {
        RC4Engine engine = this.getEngine();
        engine.init(false, (CipherParameters)params);
        byte[] array = buffer.array();
        engine.processBytes(array, 0, array.length, array, 0);
    }

    public ByteBuffer encodePage(ByteBuffer buffer, int pageNumber, int pageOffset) {
        throw new UnsupportedOperationException("Encryption is currently not supported");
    }

    protected static ByteBuffer readHeaderPage(PageChannel pageChannel) throws IOException {
        ByteBuffer buffer = pageChannel.createPageBuffer();
        pageChannel.readPage(buffer, 0);
        return buffer;
    }

    protected static byte[] applyPageNumber(byte[] key, int offset, int pageNumber) {
        byte[] tmp = ByteUtil.copyOf((byte[])key, (int)key.length);
        ByteBuffer bb = ByteBuffer.wrap(tmp).order(PageChannel.DEFAULT_BYTE_ORDER);
        bb.position(offset);
        bb.putInt(pageNumber);
        for (int i = offset; i < offset + 4; ++i) {
            int n = i;
            tmp[n] = (byte)(tmp[n] ^ key[i]);
        }
        return tmp;
    }
}

