/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;

public final class SinkBuilder<W, T> {
    private final DistributedFunction<? super JetInstance, ? extends W> createFn;
    private DistributedBiConsumer<? super W, ? super T> onReceiveFn;
    private DistributedConsumer<? super W> flushFn = DistributedFunctions.noopConsumer();
    private DistributedConsumer<? super W> destroyFn = DistributedFunctions.noopConsumer();

    SinkBuilder(@Nonnull DistributedFunction<? super JetInstance, ? extends W> createFn) {
        this.createFn = createFn;
    }

    @Nonnull
    public SinkBuilder<W, T> onReceiveFn(@Nonnull DistributedBiConsumer<? super W, ? super T> onReceiveFn) {
        this.onReceiveFn = onReceiveFn;
        return this;
    }

    @Nonnull
    public SinkBuilder<W, T> flushFn(@Nonnull DistributedConsumer<? super W> flushFn) {
        this.flushFn = flushFn;
        return this;
    }

    @Nonnull
    public SinkBuilder<W, T> destroyFn(@Nonnull DistributedConsumer<? super W> destroyFn) {
        this.destroyFn = destroyFn;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        Preconditions.checkNotNull(this.onReceiveFn, "onReceiveFn must be set");
        DistributedFunction createFn = this.createFn;
        DistributedSupplier<Processor> supplier = SinkProcessors.writeBufferedP(ctx -> createFn.apply(ctx.jetInstance()), this.onReceiveFn, this.flushFn, this.destroyFn);
        return new SinkImpl("custom-sink", ProcessorMetaSupplier.of(supplier, 2));
    }
}

