/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.pipeline.JetEvent;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.MemoizingSupplier;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.AbstractEntryProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public final class Util {
    private static final int BUFFER_SIZE = 32768;
    private static final char[] ID_TEMPLATE = "0000-0000-0000-0000".toCharArray();
    private static final DateTimeFormatter LOCAL_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");

    private Util() {
    }

    public static <T> Supplier<T> memoize(Supplier<T> onceSupplier) {
        return new MemoizingSupplier<T>(onceSupplier);
    }

    public static <T> Supplier<T> memoizeConcurrent(Supplier<T> onceSupplier) {
        return new ConcurrentMemoizingSupplier<T>(onceSupplier);
    }

    public static <T> T uncheckCall(@Nonnull Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static void uncheckRun(@Nonnull RunnableExc r) {
        try {
            r.run();
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> ExecutionCallback<T> callbackOf(final Consumer<T> onResponse, final Consumer<Throwable> onError) {
        return new ExecutionCallback<T>(){

            @Override
            public void onResponse(T o) {
                onResponse.accept(o);
            }

            @Override
            public void onFailure(Throwable throwable) {
                onError.accept(throwable);
            }
        };
    }

    @CheckReturnValue
    public static boolean tryIncrement(AtomicInteger value, int increment, int limit) {
        int next;
        int prev;
        do {
            if ((next = (prev = value.get()) + increment) <= limit) continue;
            return false;
        } while (!value.compareAndSet(prev, next));
        return true;
    }

    @Nonnull
    public static List<Address> getRemoteMembers(@Nonnull NodeEngine engine) {
        Member localMember = engine.getLocalMember();
        return engine.getClusterService().getMembers().stream().filter(m -> !m.equals(localMember)).map(Member::getAddress).collect(Collectors.toList());
    }

    public static Connection getMemberConnection(@Nonnull NodeEngine engine, @Nonnull Address memberAddr) {
        return ((NodeEngineImpl)engine).getNode().getConnectionManager().getConnection(memberAddr);
    }

    public static JetInstance getJetInstance(NodeEngine nodeEngine) {
        return ((JetService)nodeEngine.getService("hz:impl:jetService")).getJetInstance();
    }

    @Nonnull
    public static BufferObjectDataOutput createObjectDataOutput(@Nonnull NodeEngine engine) {
        return ((InternalSerializationService)engine.getSerializationService()).createObjectDataOutput(32768);
    }

    @Nonnull
    public static BufferObjectDataInput createObjectDataInput(@Nonnull NodeEngine engine, @Nonnull byte[] buf) {
        return ((InternalSerializationService)engine.getSerializationService()).createObjectDataInput(buf);
    }

    @Nonnull
    public static byte[] readFully(@Nonnull InputStream in) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int len;
            byte[] b = new byte[32768];
            while ((len = in.read(b)) != -1) {
                out.write(b, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void writeList(@Nonnull ObjectDataOutput output, @Nonnull List list) throws IOException {
        output.writeInt(list.size());
        for (Object o : list) {
            output.writeObject(o);
        }
    }

    @Nonnull
    public static <E> List<E> readList(@Nonnull ObjectDataInput output) throws IOException {
        int length = output.readInt();
        ArrayList list = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            list.add(output.readObject());
        }
        return list;
    }

    public static long addClamped(long a, long b) {
        long sum = a + b;
        return Util.sumHadOverflow(a, b, sum) ? (a >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE) : sum;
    }

    public static long subtractClamped(long a, long b) {
        long diff = a - b;
        return Util.diffHadOverflow(a, b, diff) ? (a >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE) : diff;
    }

    public static boolean sumHadOverflow(long a, long b, long sum) {
        return ((a ^ sum) & (b ^ sum)) < 0L;
    }

    public static boolean diffHadOverflow(long a, long b, long diff) {
        return ((a ^ b) & (a ^ diff)) < 0L;
    }

    public static void checkSerializable(Object object, String objectName) {
        if (object == null) {
            return;
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("\"" + objectName + "\" must implement Serializable");
        }
        try (ObjectOutputStream os = new ObjectOutputStream(new NullOutputStream());){
            os.writeObject(object);
        }
        catch (InvalidClassException | NotSerializableException e) {
            throw new IllegalArgumentException("\"" + objectName + "\" must be serializable", e);
        }
        catch (IOException e) {
            throw new JetException(e);
        }
    }

    public static Map<Integer, List<Integer>> processorToPartitions(int count, List<Integer> ownedPartitions) {
        Map<Integer, List<Integer>> processorToPartitions = IntStream.range(0, ownedPartitions.size()).mapToObj(i -> com.hazelcast.jet.Util.entry(i, ownedPartitions.get(i))).collect(Collectors.groupingBy(e -> (Integer)e.getKey() % count, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        for (int processor = 0; processor < count; ++processor) {
            processorToPartitions.computeIfAbsent(processor, x -> Collections.emptyList());
        }
        return processorToPartitions;
    }

    public static long secureRandomNextLong() {
        return Holder.NUMBER_GENERATOR.nextLong();
    }

    public static String jobAndExecutionId(long jobId, long executionId) {
        return "job " + Util.idToString(jobId) + ", execution " + Util.idToString(executionId);
    }

    public static ZonedDateTime toZonedDateTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long timestamp) {
        return Util.toZonedDateTime(timestamp).toLocalDateTime();
    }

    public static String toLocalTime(long timestamp) {
        return Util.toZonedDateTime(timestamp).toLocalTime().format(LOCAL_TIME_FORMATTER);
    }

    public static String idToString(long id) {
        char[] buf = Arrays.copyOf(ID_TEMPLATE, ID_TEMPLATE.length);
        String hexStr = Long.toHexString(id);
        int i = hexStr.length() - 1;
        int j = 18;
        while (i >= 0) {
            buf[j] = hexStr.charAt(i);
            if (j == 15 || j == 10 || j == 5) {
                --j;
            }
            --i;
            --j;
        }
        return new String(buf);
    }

    public static <K, V> EntryProcessor<K, V> entryProcessor(final DistributedBiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return new AbstractEntryProcessor<K, V>(){

            @Override
            public Object process(Map.Entry<K, V> entry) {
                Object newValue = remappingFunction.apply(entry.getKey(), entry.getValue());
                entry.setValue(newValue);
                return newValue;
            }
        };
    }

    public static <K, V> V compute(IMap<K, V> map, K key, DistributedBiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)map.executeOnKey(key, Util.entryProcessor(remappingFunction));
    }

    public static int arrayIndexOf(int needle, int[] haystack) {
        for (int i = 0; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(@Nonnull Throwable exception) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(exception);
        return future;
    }

    public static void logLateEvent(ILogger logger, long currentWm, @Nonnull Object item) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        if (item instanceof JetEvent) {
            JetEvent event = (JetEvent)item;
            logger.info(String.format("Event dropped, late by %dms. currentWatermark=%s, eventTime=%s, event=%s", currentWm - event.timestamp(), Util.toLocalTime(currentWm), Util.toLocalTime(event.timestamp()), event.payload()));
        } else {
            logger.info(String.format("Late event dropped. currentWatermark=%s, event=%s", new Watermark(currentWm), item));
        }
    }

    public static long gcd(long ... values) {
        long res = 0L;
        for (long value : values) {
            res = Util.gcd(res, value);
        }
        return res;
    }

    public static long gcd(long a, long b) {
        a = Math.abs(a);
        if ((b = Math.abs(b)) == 0L) {
            return a;
        }
        return Util.gcd(b, a % b);
    }

    private static class Holder {
        static final SecureRandom NUMBER_GENERATOR = new SecureRandom();

        private Holder() {
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) {
        }
    }

    public static interface RunnableExc {
        public void run() throws Exception;
    }
}

