/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.processor.HashJoinCollectP;
import com.hazelcast.jet.impl.processor.HashJoinP;
import com.hazelcast.jet.pipeline.JoinClause;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HashJoinTransform<T0, R>
extends AbstractTransform {
    @Nonnull
    private final List<JoinClause<?, ? super T0, ?, ?>> clauses;
    @Nonnull
    private final List<Tag> tags;
    @Nullable
    private final DistributedBiFunction mapToOutputBiFn;
    @Nullable
    private final DistributedTriFunction mapToOutputTriFn;

    public HashJoinTransform(@Nonnull List<Transform> upstream, @Nonnull List<JoinClause<?, ? super T0, ?, ?>> clauses, @Nonnull List<Tag> tags, @Nonnull DistributedBiFunction mapToOutputBiFn) {
        super(upstream.size() + "-way hash-join", upstream);
        this.clauses = clauses;
        this.tags = tags;
        this.mapToOutputBiFn = mapToOutputBiFn;
        this.mapToOutputTriFn = null;
    }

    public <T1, T2> HashJoinTransform(@Nonnull List<Transform> upstream, @Nonnull List<JoinClause<?, ? super T0, ?, ?>> clauses, @Nonnull List<Tag> tags, @Nonnull DistributedTriFunction<T0, T1, T2, R> mapToOutputTriFn) {
        super(upstream.size() + "-way hash-join", upstream);
        this.clauses = clauses;
        this.tags = tags;
        this.mapToOutputBiFn = null;
        this.mapToOutputTriFn = mapToOutputTriFn;
    }

    @Override
    public void addToDag(Planner p) {
        String namePrefix = p.uniqueVertexName(this.name(), "");
        Planner.PlannerVertex primary = p.xform2vertex.get(this.upstream().get(0));
        List keyFns = this.clauses.stream().map(JoinClause::leftKeyFn).collect(Collectors.toList());
        List<Tag> tags = this.tags;
        DistributedBiFunction mapToOutputBiFn = this.mapToOutputBiFn;
        DistributedTriFunction mapToOutputTriFn = this.mapToOutputTriFn;
        Vertex joiner = p.addVertex((Transform)this, (String)new StringBuilder().append((String)namePrefix).append((String)"-joiner").toString(), (int)this.localParallelism(), (DistributedSupplier<Processor>)(DistributedSupplier)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, lambda$addToDag$50528d84$1(java.util.List java.util.List com.hazelcast.jet.function.DistributedBiFunction com.hazelcast.jet.function.DistributedTriFunction ), ()Lcom/hazelcast/jet/core/Processor;)(keyFns, tags, (DistributedBiFunction)mapToOutputBiFn, (DistributedTriFunction)mapToOutputTriFn)).v;
        p.dag.edge(Edge.from(primary.v, primary.nextAvailableOrdinal()).to(joiner, 0));
        String collectorName = namePrefix + "-collector";
        int collectorOrdinal = 1;
        for (Transform fromTransform : Planner.tailList(this.upstream())) {
            Planner.PlannerVertex fromPv = p.xform2vertex.get(fromTransform);
            JoinClause<?, T0, ?, ?> clause = this.clauses.get(collectorOrdinal - 1);
            DistributedFunction<?, ?> getKeyFn = clause.rightKeyFn();
            DistributedFunction<?, ?> projectFn = clause.rightProjectFn();
            Vertex collector = p.dag.newVertex(collectorName + collectorOrdinal, () -> new HashJoinCollectP(getKeyFn, projectFn));
            collector.localParallelism(1);
            p.dag.edge(Edge.from(fromPv.v, fromPv.nextAvailableOrdinal()).to(collector, 0).distributed().broadcast());
            p.dag.edge(Edge.from(collector, 0).to(joiner, collectorOrdinal).broadcast().priority(-1));
            ++collectorOrdinal;
        }
    }

    private static /* synthetic */ Processor lambda$addToDag$50528d84$1(List keyFns, List tags, DistributedBiFunction mapToOutputBiFn, DistributedTriFunction mapToOutputTriFn) {
        return new HashJoinP(keyFns, tags, mapToOutputBiFn, mapToOutputTriFn);
    }
}

