/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.operation.AbstractJobOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ExceptionAction;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class InitExecutionOperation
extends AbstractJobOperation {
    private long executionId;
    private int coordinatorMemberListVersion;
    private Set<MemberInfo> participants;
    private Data serializedPlan;

    public InitExecutionOperation() {
    }

    public InitExecutionOperation(long jobId, long executionId, int coordinatorMemberListVersion, Set<MemberInfo> participants, Data serializedPlan) {
        super(jobId);
        this.executionId = executionId;
        this.coordinatorMemberListVersion = coordinatorMemberListVersion;
        this.participants = participants;
        this.serializedPlan = serializedPlan;
    }

    @Override
    public void run() {
        ILogger logger = this.getLogger();
        JetService service = (JetService)this.getService();
        Address caller = this.getCallerAddress();
        logger.fine("Initializing execution plan for " + Util.jobAndExecutionId(this.jobId(), this.executionId) + " from " + caller);
        ExecutionPlan plan = this.deserializePlan(this.serializedPlan);
        service.getJobExecutionService().initExecution(this.jobId(), this.executionId, caller, this.coordinatorMemberListVersion, this.participants, plan);
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isTopologicalFailure(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeInt(this.coordinatorMemberListVersion);
        out.writeInt(this.participants.size());
        for (MemberInfo participant : this.participants) {
            participant.writeData(out);
        }
        out.writeData(this.serializedPlan);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.coordinatorMemberListVersion = in.readInt();
        int count = in.readInt();
        this.participants = new HashSet<MemberInfo>();
        for (int i = 0; i < count; ++i) {
            MemberInfo participant = new MemberInfo();
            participant.readData(in);
            this.participants.add(participant);
        }
        this.serializedPlan = in.readData();
    }

    private ExecutionPlan deserializePlan(Data planBlob) {
        JetService service = (JetService)this.getService();
        ClassLoader cl = service.getClassLoader(this.jobId());
        return (ExecutionPlan)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.getNodeEngine().getSerializationService(), cl, planBlob);
    }
}

