/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.serialization.SerializationService;
import javax.annotation.Nonnull;

public final class Contexts {
    private Contexts() {
    }

    public static class ProcCtx
    extends ProcSupplierCtx
    implements Processor.Context {
        private final int index;
        private final SerializationService serService;
        private final ProcessingGuarantee processingGuarantee;

        public ProcCtx(JetInstance instance, SerializationService serService, ILogger logger, String vertexName, int index, ProcessingGuarantee processingGuarantee, int localParallelism, int totalParallelism, int memberIndex, int memberCount) {
            super(instance, logger, vertexName, localParallelism, totalParallelism, memberIndex, memberCount);
            this.serService = serService;
            this.index = index;
            this.processingGuarantee = processingGuarantee;
        }

        @Override
        public int globalProcessorIndex() {
            return this.index;
        }

        @Override
        public ProcessingGuarantee processingGuarantee() {
            return this.processingGuarantee;
        }

        public SerializationService getSerializationService() {
            return this.serService;
        }
    }

    static class ProcSupplierCtx
    extends MetaSupplierCtx
    implements ProcessorSupplier.Context {
        private final int memberIndex;

        ProcSupplierCtx(JetInstance jetInstance, ILogger logger, String vertexName, int localParallelism, int totalParallelism, int memberIndex, int memberCount) {
            super(jetInstance, logger, vertexName, localParallelism, totalParallelism, memberCount);
            this.memberIndex = memberIndex;
        }

        @Override
        public int memberIndex() {
            return this.memberIndex;
        }
    }

    static class MetaSupplierCtx
    implements ProcessorMetaSupplier.Context {
        private final JetInstance jetInstance;
        private final ILogger logger;
        private final String vertexName;
        private final int localParallelism;
        private final int totalParallelism;
        private final int memberCount;

        MetaSupplierCtx(JetInstance jetInstance, ILogger logger, String vertexName, int localParallelism, int totalParallelism, int memberCount) {
            this.jetInstance = jetInstance;
            this.logger = logger;
            this.vertexName = vertexName;
            this.totalParallelism = totalParallelism;
            this.localParallelism = localParallelism;
            this.memberCount = memberCount;
        }

        @Override
        @Nonnull
        public JetInstance jetInstance() {
            return this.jetInstance;
        }

        @Override
        public int totalParallelism() {
            return this.totalParallelism;
        }

        @Override
        public int localParallelism() {
            return this.localParallelism;
        }

        @Override
        public int memberCount() {
            return this.memberCount;
        }

        @Override
        @Nonnull
        public String vertexName() {
            return this.vertexName;
        }

        @Override
        @Nonnull
        public ILogger logger() {
            return this.logger;
        }
    }
}

