/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class WriteBufferedP<B, T>
implements Processor {
    private final DistributedFunction<? super Processor.Context, B> createFn;
    private final DistributedBiConsumer<? super B, ? super T> onReceiveFn;
    private final DistributedConsumer<? super B> flushFn;
    private DistributedConsumer<? super B> destroyFn;
    private B buffer;

    WriteBufferedP(@Nonnull DistributedFunction<? super Processor.Context, B> createFn, @Nonnull DistributedBiConsumer<? super B, ? super T> onReceiveFn, @Nonnull DistributedConsumer<? super B> flushFn, @Nonnull DistributedConsumer<? super B> destroyFn) {
        this.createFn = createFn;
        this.onReceiveFn = onReceiveFn;
        this.flushFn = flushFn;
        this.destroyFn = destroyFn;
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.buffer = this.createFn.apply(context);
        if (this.buffer == null) {
            throw new JetException("Null buffer created");
        }
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        inbox.drain(item -> this.onReceiveFn.accept(this.buffer, item));
        this.flushFn.accept(this.buffer);
    }

    @Override
    public boolean complete() {
        this.close(null);
        return true;
    }

    @Override
    public void close(@Nullable Throwable error) {
        if (this.destroyFn != null && this.buffer != null) {
            this.destroyFn.accept(this.buffer);
            this.destroyFn = null;
        }
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    @Nonnull
    public static <B, T> DistributedSupplier<Processor> supplier(@Nonnull DistributedFunction<? super Processor.Context, ? extends B> createFn, @Nonnull DistributedBiConsumer<? super B, ? super T> onReceiveFn, @Nonnull DistributedConsumer<? super B> flushFn, @Nonnull DistributedConsumer<? super B> destroyFn) {
        return () -> new WriteBufferedP(createFn, onReceiveFn, flushFn, destroyFn);
    }
}

