/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.AbstractConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.config.XmlJetConfigLocator;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.StringUtil;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XmlJetConfigBuilder
extends AbstractConfigBuilder {
    private static final ILogger LOGGER = Logger.getLogger(XmlJetConfigBuilder.class);
    private final Properties properties;
    private final JetConfig jetConfig = new JetConfig();

    private XmlJetConfigBuilder(Properties properties, InputStream in) {
        this.properties = properties;
        try {
            this.parseAndBuildConfig(in);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    public static JetConfig loadConfig(@Nullable InputStream stream, @Nullable Properties properties) {
        if (properties == null) {
            properties = System.getProperties();
        }
        if (stream == null) {
            stream = XmlJetConfigLocator.getJetConfigStream(properties);
        }
        JetConfig cfg = new XmlJetConfigBuilder((Properties)properties, (InputStream)stream).jetConfig;
        cfg.setHazelcastConfig(XmlJetConfigBuilder.getMemberConfig(properties));
        return cfg;
    }

    public static ClientConfig getClientConfig() {
        return XmlJetConfigBuilder.getClientConfig(System.getProperties());
    }

    public static ClientConfig getClientConfig(Properties properties) {
        return new XmlClientConfigBuilder(XmlJetConfigLocator.getClientConfigStream(properties)).build();
    }

    private static Config getMemberConfig(Properties properties) {
        return new XmlConfigBuilder(XmlJetConfigLocator.getMemberConfigStream(properties)).build();
    }

    @Override
    protected Document parse(InputStream inputStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        try {
            Document document = builder.parse(inputStream);
            return document;
        }
        catch (Exception e) {
            String msg = "Failed to parse config" + StringUtil.LINE_SEPARATOR + "Exception: " + e.getMessage() + StringUtil.LINE_SEPARATOR + "Hazelcast Jet startup interrupted.";
            LOGGER.severe(msg);
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
        finally {
            IOUtil.closeResource(inputStream);
        }
    }

    @Override
    protected Properties getProperties() {
        return this.properties;
    }

    @Override
    protected AbstractConfigBuilder.ConfigType getXmlType() {
        return AbstractConfigBuilder.ConfigType.JET;
    }

    @Override
    public String getNamespaceType() {
        return "jet-config";
    }

    @Override
    protected String getReleaseVersion() {
        BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();
        JetBuildInfo jetBuildInfo = buildInfo.getJetBuildInfo();
        return jetBuildInfo.getVersion().substring(0, 3);
    }

    private void parseAndBuildConfig(InputStream in) throws Exception {
        Document doc = this.parse(in);
        Element root = doc.getDocumentElement();
        try {
            root.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.process(root);
        this.schemaValidation(root.getOwnerDocument());
        this.handleConfig(root);
    }

    private void handleConfig(Element docElement) {
        block10: for (Node node : XmlJetConfigBuilder.childElements(docElement)) {
            String name;
            switch (name = XmlJetConfigBuilder.cleanNodeName(node)) {
                case "instance": {
                    this.parseInstanceConfig(node);
                    continue block10;
                }
                case "properties": {
                    this.fillProperties(node, this.jetConfig.getProperties());
                    continue block10;
                }
                case "edge-defaults": {
                    this.parseEdgeDefaults(node);
                    continue block10;
                }
            }
            throw new AssertionError((Object)("Unrecognized XML element: " + name));
        }
    }

    private void parseInstanceConfig(Node instanceNode) {
        InstanceConfig instanceConfig = this.jetConfig.getInstanceConfig();
        block12: for (Node node : XmlJetConfigBuilder.childElements(instanceNode)) {
            String name;
            switch (name = XmlJetConfigBuilder.cleanNodeName(node)) {
                case "cooperative-thread-count": {
                    instanceConfig.setCooperativeThreadCount(this.intValue(node));
                    continue block12;
                }
                case "temp-dir": {
                    instanceConfig.setTempDir(this.stringValue(node));
                    continue block12;
                }
                case "flow-control-period": {
                    instanceConfig.setFlowControlPeriodMs(this.intValue(node));
                    continue block12;
                }
                case "backup-count": {
                    instanceConfig.setBackupCount(this.intValue(node));
                    continue block12;
                }
            }
            throw new AssertionError((Object)("Unrecognized XML element: " + name));
        }
    }

    private void parseEdgeDefaults(Node edgeNode) {
        EdgeConfig config = this.jetConfig.getDefaultEdgeConfig();
        block10: for (Node child : XmlJetConfigBuilder.childElements(edgeNode)) {
            String name;
            switch (name = XmlJetConfigBuilder.cleanNodeName(child)) {
                case "queue-size": {
                    config.setQueueSize(this.intValue(child));
                    continue block10;
                }
                case "packet-size-limit": {
                    config.setPacketSizeLimit(this.intValue(child));
                    continue block10;
                }
                case "receive-window-multiplier": {
                    config.setReceiveWindowMultiplier(this.intValue(child));
                    continue block10;
                }
            }
            throw new AssertionError((Object)("Unrecognized XML element: " + name));
        }
    }

    private int intValue(Node node) {
        return Integer.parseInt(this.stringValue(node));
    }

    private String stringValue(Node node) {
        return this.getTextContent(node);
    }
}

