/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.impl.JetInstanceImpl;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.LiveOperationRegistry;
import com.hazelcast.jet.impl.Networking;
import com.hazelcast.jet.impl.SnapshotRepository;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.ConfigurableService;
import com.hazelcast.spi.LiveOperations;
import com.hazelcast.spi.LiveOperationsTracker;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PacketHandler;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class JetService
implements ManagedService,
ConfigurableService<JetConfig>,
PacketHandler,
MembershipAwareService,
LiveOperationsTracker {
    public static final int MAX_PARALLEL_ASYNC_OPS = 1000;
    public static final String SERVICE_NAME = "hz:impl:jetService";
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final LiveOperationRegistry liveOperationRegistry;
    private JetConfig config;
    private JetInstance jetInstance;
    private Networking networking;
    private TaskletExecutionService taskletExecutionService;
    private JobRepository jobRepository;
    private JobCoordinationService jobCoordinationService;
    private JobExecutionService jobExecutionService;
    private final AtomicInteger numConcurrentAsyncOps = new AtomicInteger();
    private final Supplier<int[]> sharedPartitionKeys = Util.memoizeConcurrent(this::computeSharedPartitionKeys);

    public JetService(NodeEngine nodeEngine) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.liveOperationRegistry = new LiveOperationRegistry();
    }

    @Override
    public void configure(JetConfig config) {
        this.config = config;
    }

    @Override
    public void init(NodeEngine engine, Properties properties) {
        if (this.config == null) {
            throw new IllegalStateException("JetConfig is not initialized");
        }
        this.jetInstance = new JetInstanceImpl((HazelcastInstanceImpl)engine.getHazelcastInstance(), this.config);
        this.taskletExecutionService = new TaskletExecutionService(this.nodeEngine.getHazelcastInstance(), this.config.getInstanceConfig().getCooperativeThreadCount());
        SnapshotRepository snapshotRepository = new SnapshotRepository(this.jetInstance);
        this.jobRepository = new JobRepository(this.jetInstance, snapshotRepository);
        this.jobExecutionService = new JobExecutionService(this.nodeEngine, this.taskletExecutionService);
        this.jobCoordinationService = new JobCoordinationService(this.nodeEngine, this.config, this.jobRepository, this.jobExecutionService, snapshotRepository);
        this.networking = new Networking(engine, this.jobExecutionService, this.config.getInstanceConfig().getFlowControlPeriodMs());
        ClientEngineImpl clientEngine = (ClientEngineImpl)engine.getService("hz:core:clientEngine");
        ExceptionUtil.registerJetExceptions(clientEngine.getClientExceptionFactory());
        this.jobCoordinationService.init();
        JetBuildInfo jetBuildInfo = BuildInfoProvider.getBuildInfo().getJetBuildInfo();
        this.logger.info(String.format("Starting Jet %s (%s - %s)", jetBuildInfo.getVersion(), jetBuildInfo.getBuild(), jetBuildInfo.getRevision()));
        this.logger.info("Setting number of cooperative threads and default parallelism to " + this.config.getInstanceConfig().getCooperativeThreadCount());
        this.logger.info("\n\to   o   o   o---o o---o o     o---o   o   o---o o-o-o        o o---o o-o-o\n\t|   |  / \\     /  |     |     |      / \\  |       |          | |       |  \n\to---o o---o   o   o-o   |     o     o---o o---o   |          | o-o     |  \n\t|   | |   |  /    |     |     |     |   |     |   |      \\   | |       |  \n\to   o o   o o---o o---o o---o o---o o   o o---o   o       o--o o---o   o   ");
        this.logger.info("Copyright (c) 2008-2018, Hazelcast, Inc. All Rights Reserved.");
    }

    @Override
    public void shutdown(boolean terminate) {
        this.jobExecutionService.reset("shutdown", HazelcastInstanceNotActiveException::new);
        this.networking.shutdown();
        this.taskletExecutionService.shutdown();
    }

    @Override
    public void reset() {
        this.jobCoordinationService.reset();
        this.jobExecutionService.reset("reset", TopologyChangedException::new);
    }

    public JetInstance getJetInstance() {
        return this.jetInstance;
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public JobCoordinationService getJobCoordinationService() {
        return this.jobCoordinationService;
    }

    public JobExecutionService getJobExecutionService() {
        return this.jobExecutionService;
    }

    public ClassLoader getClassLoader(long jobId) {
        return this.jobCoordinationService.getClassLoader(jobId);
    }

    @Override
    public void handle(Packet packet) throws IOException {
        this.networking.handle(packet);
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        Address address = event.getMember().getAddress();
        this.jobExecutionService.onMemberLeave(address);
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
        this.jobCoordinationService.updateQuorumValues();
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    public AtomicInteger numConcurrentAsyncOps() {
        return this.numConcurrentAsyncOps;
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        this.liveOperationRegistry.populate(liveOperations);
    }

    public int[] getSharedPartitionKeys() {
        return this.sharedPartitionKeys.get();
    }

    private int[] computeSharedPartitionKeys() {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        int[] keys = new int[partitionService.getPartitionCount()];
        int remainingCount = partitionService.getPartitionCount();
        int i = 1;
        while (remainingCount > 0) {
            int partitionId = partitionService.getPartitionId(i);
            if (keys[partitionId] == 0) {
                keys[partitionId] = i;
                --remainingCount;
            }
            ++i;
        }
        return keys;
    }
}

